/*
 * CONVOLVE	-	Do filter H filter convolution with boundary
 */

#include <stdio.h>


/*
 * ACCESSC handles negative accesses, as well as those that exceed the number
 * of elements
 */

/*
#define REFLECT(n, lengthC)	( ((n)<0) ? (-1-(n)) : ((n)<(lengthC) ? (n) : (2*(lengthC)-(n)-1))) 
*/
#define	ACCESSC(c, firstC, lengthC, ix) *(c+reflect(((ix)-(firstC)),(lengthC)))


int convolveC(c_in, lengthcin, firstcin, H, lengthh, c_out, lengthcout,
    firstcout, lastcout)
double *c_in;	/* Input data						*/
long *lengthcin;/* Length of this array					*/
long *firstcin;
double *H;	/* Filter						*/
long *lengthh;	/* Length of filter					*/
double *c_out;	/* Output data						*/
long *lengthcout;/* Length of above array				*/
long *firstcout;/* First index of C array				*/
long *lastcout;	/* Last index of C array				*/
{
double sum;
register int k;
register int count_out;
register int m;
int LengthH;
int LengthCin;
int firstCin;
int LengthCout;
int firstCout;
int lastCout;

LengthH = (int)*lengthh;
LengthCin = (int)*lengthcin;
firstCin = (int)*firstcin;
LengthCout = (int)*lengthcout;
firstCout = (int)*firstcout;
lastCout = (int)*lastcout;

count_out = 0;

for(k=firstCout; k<=lastCout; ++k)	{
	sum = 0.0;


	for(m=0; m<LengthH; ++m)	{

		sum += *(H+m) * ACCESSC(c_in, firstCin, LengthCin, (m+2*k));
		}

	*(c_out + count_out) = sum;
	++count_out;
	}
}

int convolveD(c_in, lengthcin, firstcin, H, lengthh, d_out, lengthdout,
    firstdout, lastdout)
double *c_in;	/* Input data						*/
long *lengthcin;/* Length of this array					*/
long *firstcin;
double *H;	/* Filter						*/
long *lengthh;	/* Length of filter					*/
double *d_out;	/* Output data						*/
long *lengthdout;/* Length of above array				*/
long *firstdout;/* First index of D array				*/
long *lastdout;	/* Last index of D array				*/
{
double sum;
register int k;
register int count_out;
register int m;
int LengthH;
int LengthCin;
int firstCin;
int LengthDout;
int firstDout;
int lastDout;

LengthH = (int)*lengthh;
LengthCin = (int)*lengthcin;
firstCin = (int)*firstcin;
LengthDout = (int)*lengthdout;
firstDout = (int)*firstdout;
lastDout = (int)*lastdout;

count_out = 0;

for(k=firstDout; k<=lastDout; ++k)	{
	sum = 0.0;


	for(m=0; m<LengthH; ++m)	{

		
		if (m&1)	/* odd */
			sum += *(H+m) * ACCESSC(c_in, firstCin, LengthCin, (2*k+1-m));
		else
			sum -= *(H+m) * ACCESSC(c_in, firstCin, LengthCin, (2*k+1-m));
		
		}

	*(d_out + count_out) = sum;
	++count_out;
	}
}


/* Works out reflection, as REFLECT, but reports access errors */
int reflect(n, lengthC)
int n;
int lengthC;
{

if ((n >= 0) && (n < lengthC))
	return(n);
else if (n<0)	{
	n = -1-n;
	if (n >= lengthC)	{
		fprintf(stderr, "reflect: access error (%d,%d)\n", n,lengthC);
		exit(2);
		}
	else
		return(n);
	}
else	{
	n = 2*lengthC - n - 1;
	if (n<0)	{
		fprintf(stderr, "reflect: access error (%d,%d)\n", n,lengthC);
		exit(3);
		}
	else
		return(n);
	}
/* Safety */
fprintf(stderr, "reflect: SHOULD NOT HAVE REACHED THIS POINT\n");
exit(4);
}
