library.dynam("gee.so")

"model.extract" <- function (frame, component) 
{
	component <- as.character(substitute(component))
	rval <- switch(component, response = model.response(frame), offset = model.offset(frame
	), weights = frame$"(weights)", start = frame$"(start)",id=frame$"(id)")
	if (length(rval) == nrow(frame)) 
		names(rval) <- attr(frame, "row.names")
	else if (is.matrix(rval) && nrow(rval) == nrow(frame)) {
		t1 <- dimnames(rval)
		dimnames(rval) <- list(attr(frame, "row.names"), t1[[2]])
	}
	return(rval)
}
"as.family" <-
function (family) 
{
	if (is.character(family)) 
		family <- get(family)
	if (is.function(family)) 
		family <- family()
	if (is.null(family$family)) 
		stop("family not recognised")
        family
}
# gee Splus support @(#) geeformula.q 4.4 96/09/27
print.gee <- function(x, digits = NULL, quote = F, prefix = "")
{
# gee Splus support  @(#) geeformula.q 4.4 96/09/27
        if(is.null(digits)) digits <- options()$digits else options(digits =
                        digits)
        cat("\n", x$title)
        cat("\n", x$version, "\n")
        cat("\nModel:\n")
        cat(" Link:                     ", x$model$link, "\n")
        cat(" Variance to Mean Relation:", x$model$varfun, "\n")
        if(!is.null(x$model$M))
                cat(" Correlation Structure:    ", x$model$corstr, ", M =", x$
                        model$M, "\n")
        else cat(" Correlation Structure:    ", x$model$corstr, "\n")
        cat("\nCall:\n")
        dput(x$call)    #       cat("\nTerms:\n")
###        ys <- matrix(rep(as.matrix(x$id, ncol = 1), 5), ncol = 5)
        ys <- matrix(rep(matrix(x$id, ncol = 1), 5), ncol = 5)
        ys[, 2] <- x$y
        ys[, 3] <- x$linear.predictors
        ys[, 4] <- x$fitted.values
        ys[, 5] <- x$residuals
        dimnames(ys) <- list(1:length(x$y), c("ID", "Y", "LP", "fitted",
                "Residual"))    #       cat("\nFitted Values:\n")
        cat("\nNumber of observations : ", x$nobs, "\n")
        cat("\nMaximum cluster size   : ", x$max.id, "\n")
        nas <- x$nas
        if(any(nas))
                cat("\n\nCoefficients: (", sum(nas),
                        " not defined because of singularities)\n", sep = "")
        else cat("\n\nCoefficients:\n")
        print(x$coefficients, digits = digits)
        cat("\nEstimated Scale Parameter: ", format(round(x$scale, digits)))
        cat("\nNumber of Iterations: ", x$iterations)
###<TSL>
	four<-min(4,dim(x$working.correlation)[[1]])
        cat("\n\nWorking Correlation[1:",four,",1:",four,"]\n")
        print(x$working.correlation[1:four, 1:four], digits = digits)
###</TSL>
        cat("\n\nReturned Error Value:\n")
        print(x$error)
        invisible(x)
}

print.summary.gee <- function(x, digits = NULL, quote = F, prefix = "" )
{
# gee Splus support @(#) geeformula.q 4.4 96/09/27
	if(is.null(digits))
		digits <- options()$digits
	else options(digits = digits)
	cat("\n",x$title)
	cat("\n",x$version,"\n")
	cat("\nModel:\n")
	cat(" Link:                     ",x$model$link,"\n")
	cat(" Variance to Mean Relation:",x$model$varfun,"\n")
	if(!is.null(x$model$M))
	        cat(" Correlation Structure:    ",x$model$corstr,", M =",x$model$M,"\n")
	else 	cat(" Correlation Structure:    ",x$model$corstr,"\n")
	cat("\nCall:\n")
	dput(x$call)
	cat("\nSummary of Residuals:\n")
	print(x$residual.summary, digits = digits)
	nas <- x$nas
###	if(any(nas))
	if(!is.null(nas) && any(nas))
		cat("\n\nCoefficients: (", sum(nas), 
			" not defined because of singularities)\n", sep = "")
	else cat("\n\nCoefficients:\n")
	print(x$coefficients, digits = digits)
	cat("\nEstimated Scale Parameter: ", format(round(x$scale,digits)))
	cat("\nNumber of Iterations: ", x$iterations)
	cat("\n\nWorking Correlation\n")
	print(x$working.correlation,digits=digits)
	if(!is.null(x$naive.correlation)) {
		cat("\n\nNaive Correlation of Estimates:\n")
		print(x$naive.correlation)
	}
	if(!is.null(x$robust.correlation)) {
		cat("\n\nRobust Correlation of Estimates:\n")
		print(x$robust.correlation)
	}
	invisible(x)
}
summary.gee <- function(object, correlation = T)
{
# gee Splus support @(#) geeformula.q 4.4 96/09/27
	coef <- object$coefficients
	resid <- object$residuals
	n <- length(resid)
	p <- object$rank
	if(is.null(p))
		p <- sum(!is.na(coef))
	if(all(is.na(coef))) {
		warning("This model has zero rank --- no summary is provided")
		return(object)
	}
	nas <- is.na(coef)
	cnames <- names(coef[!nas])
	coef <- matrix(rep(coef[!nas], 5), ncol = 5)
	dimnames(coef) <- list(cnames, c("Estimate", 
			"Naive S.E.",  "Naive z", 
        		"Robust S.E.", "Robust z"))
	rse <- sqrt(diag(object$robust.variance))
	nse <- sqrt(diag(object$naive.variance))
	coef[,2] <- nse
	coef[,3] <- coef[,1]/coef[,2]
	coef[,4] <- rse
	coef[,5] <- coef[,1]/coef[,4]
	summary <- list()
	summary$call <- object$call
	summary$version <- object$version
	summary$nobs <- object$nobs
	summary$residual.summary <- quantile(as.vector(object$residuals))
	names(summary$residual.summary) <- c("Min", "1Q", "Median", "3Q", "Max")
	summary$model<- object$model
	summary$title <- object$title
	summary$coefficients <- coef
	summary$working.correlation <- object$working.correlation
	summary$scale <- object$scale
	summary$error <- paste("Error code was", object$error)
	summary$working.correlation <- object$working.correlation
	summary$iterations <- object$iterations
	if ( correlation ) {
	#	rob.var <- object$robust.variance
	#	nai.var <- object$naive.variance
	#	summary$robust.correlation <- rob.var /
	#	outer(sqrt(diag(rob.var)),sqrt(diag(rob.var)))
	#	dimnames(summary$robust.correlation) <- list(object$xnames,object$xnames)
	#	summary$naive.correlation <- nai.var /
	#	outer(sqrt(diag(nai.var)),sqrt(diag(nai.var)))
	#	dimnames(summary$naive.correlation) <- list(object$xnames,object$xnames)
	}
	attr(summary,"class") <- "summary.gee"
	summary
}
gee <- function(formula = formula(data), id = id, data = sys.parent(), 
	subset, na.action, offset = NA, R = NA, b = NA, tol = 
	0.001, maxiter = as.integer(25), family = gaussian, corstr = 
	"independence", Mv = 1, silent = T, contrasts = NULL, scale.fix = F, 
	scale.value = 1)
{
# gee Splus support @(#) geeformula.q 4.4 96/09/27
	print("Beginning Cgee S-function, @(#) geeformula.q 4.4 96/09/27"
		)
	call <- match.call()
	m <- match.call(expand = F)
	m$R <- m$b <- m$tol <- m$maxiter <- m$link <- m$varfun <-
               m$corstr <- m$Mv <- m$silent <- m$contrasts <-
               m$family <- m$scale.fix <- m$scale.value <- NULL
	if(is.null(m$id)) {
		m$id <- as.name("id")
	}
	if(is.null(m$na.action)) {
	}
	else {
		if(m$na.action != "na.omit") {
			print("Warning: Only na.omit is implemented for gee")
			print("         continuing with na.action=na.omit")
			m$na.action <- as.name("na.omit")
		}
	}
	m[[1]] <- as.name("model.frame")
##<tsl>
	m$use.data<-T
##</tsl>
	m <- eval(m, sys.parent())
	Terms <- attr(m, "terms")
	y <- as.matrix(model.extract(m, response))
## <tsl>	x <- model.matrix(Terms, m, contrasts)
### Rchange
	if (is.null(contrasts))
		x <- model.matrix(Terms, m)
	else stop("R model.matrix() can't handle contrasts argument")
### </tsl>
	N <- rep(1, length(y))
	if (dim(y)[2]==2) {
	     N <- as.vector(y %*% c(1,1))
	     y <- y[,1]
	}
	else {
             if (dim(y)[2]>2)
	     stop("Only binomial response matrices (2 columns)")
	}
	offset <- model.extract(m, offset)
	id <- model.extract(m, id)
	if(is.null(id)) {
		stop("Id variable not found")
	}
	nobs <- nrow(x)
	nc <- ncol(x)
	xnames <- dimnames(x)[[2]]
	if(is.null(xnames)) {
		xnames <- paste("x", 1:nc, sep = "")
		dimnames(x) <- list(NULL, xnames)
	}
	family <- as.family(family)
	if(deparse(substitute(b)) != "NA") {
		b <- matrix(b, ncol = 1)
		Rb <- nrow(b)
		if(Rb != nc) {
			stop("Dim beta != ncol(x)")
		}
		start.beta <- as.integer(1)
		beta <- matrix(as.double(b), ncol = 1)
	}
	else {  print("running glm to get initial regression estimate")
## <tsl>	beta <- as.numeric(glm(m, family = family)$coef)
		mm <- match.call(expand = F)
		mm$R <- mm$b <- mm$tol <- mm$maxiter <- mm$link <- mm$varfun <-mm$corstr <- mm$Mv <- mm$silent <- mm$contrasts <-mm$scale.fix <- mm$scale.value <- mm$id<-NULL
		mm[[1]]<-as.name("glm")
		beta <- as.numeric(eval(mm,sys.frame(sys.parent()))$coef)
###	</tsl>
		print(beta)
	}
	if(length(id) != length(y)) {
		stop("Id and y not same length")
	}
	p <- ncol(x)
	maxclsz <- as.integer(max(unlist(lapply(split(id, id), 
		"length"))))
	maxiter <- as.integer(maxiter)
	silent <- as.integer(silent)
	if(is.null(offset)) {
		offset <- rep(0, length(y))
	}
	else if(length(offset) == 1 && offset == 0) {
		offset <- rep(0, length(y))
	}
	else if(length(offset) != length(y)) {
		print("Warning: offset and y are not of same length")
		print("         offset being replicated to length of y")
		offset <- rep(offset, length(y))
	}
	offset <- as.double(offset)
	if(!is.na(R[1])) {
		Rr <- nrow(R)
		Rc <- ncol(R)
		R <- matrix(R, ncol = Rc)
		if(Rr != Rc) {
			stop("R is not square!")
		}
		if(Rr < maxclsz) {
			stop("R not big enough to accommodate some clusters.")
		}
	}
	else {
		R <- matrix(as.double(rep(0, maxclsz * maxclsz)), nrow = 
			maxclsz)
	}
	links <- c("identity", "logarithm", "logit", "reciprocal", "probit",
"cloglog")
	varfuns <- c("gaussian", "poisson", "binomial", "gamma")
	corstrs <- c("independence", "fixed", "stat_M_dep", "non_stat_M_dep", 
		"exchangeable", "AR-M", "unstructured")
#	defam <- function(x)
#	{
# function to get the essential components from family arg
#		xfam <- unclass(family(x))$family
#		c(xfam["link"], xfam["variance"])
#	}
#	glmlinks <- unlist(glm.links["name",  ])
#	geelinks <- glmlinks[c(1, 5, 2, 6, 4, 3)]	# match ordering known to cgee
#	glmvars <- unlist(glm.variances["name",  ])
#	geevars <- glmvars[c(1, 3, 2, 4)]
	thisfam <- family$family
	link <- family$link
	varfun <- family$family
	linkv <- as.integer(match(c(link), links, -1))
	varfunv <- as.integer(match(c(varfun), varfuns, -1))
	corstrv <- as.integer(match(c(corstr), corstrs, -1))
	if(linkv < 1)
		stop("unknown link.")
	if(varfunv < 1)
		stop("unknown varfun.")
	if(corstrv < 1)
		stop("unknown corstr.")
	naivvar <- matrix(rep(0, p * p), nrow = p)
	robvar <- matrix(rep(0, p * p), nrow = p)
	phi <- as.double(scale.value)
	scale.fix <- as.integer(scale.fix)
	errstate <- as.integer(1)
	tol <- as.double(tol)
	Mv <- as.integer(Mv)
	maxcl <- as.integer(0)
	if(!(is.double(x)))
		x <- as.double(x)
	if(!(is.double(y)))
		y <- as.double(y)
	if(!(is.double(id)))
		id <- as.double(id)
	if(!(is.double(N)))
		N <- as.double(N)
	modvec <- as.integer(c(linkv, varfunv, corstrv))
	z <- .C("Cgee",
		x,
		y,
		id,
		N,
		offset,
		nobs,
		p,
		modvec,
		Mv,
		estb = beta,
		nv = naivvar,
		rv = robvar,
		sc = phi,
		wcor = R,
		tol,
		mc = maxcl,
		iter = maxiter,
		silent,
		err = errstate,
		scale.fix)
	if(z$err != 0)
		warning(paste("Note: Cgee had an error (code=", z$err, 
			").  Results suspect."))
	if(min(eigen(z$wcor)$values) < 0) {
		warning("Working correlation estimate not positive definite")
		z$err <- z$err + 1000
	}
	fit <- list()
## <tsl>	attr(fit, "class") <- c("gee", "glm")
	fit$title <- "GEE:  GENERALIZED LINEAR MODELS FOR DEPENDENT DATA"
	fit$version <- "gee S-function, version 4.4 modified 96/09/27 (1996)"
	links <- c("Identity", "Logarithm", "Logit", "Reciprocal", "Probit",
"Cloglog")
	varfuns <- c("Gaussian", "Poisson", "Binomial", "Gamma")
	corstrs <- c("Independent", "Fixed", "Stationary M-dependent", 
		"Non-Stationary M-dependent", "Exchangeable", "AR-M", 
		"Unstructured")
	fit$model <- list()
	fit$model$link <- links[linkv]
	fit$model$varfun <- varfuns[varfunv]
	fit$model$corstr <- corstrs[corstrv]
	if(!is.na(match(c(corstrv), c(3, 4, 6))))
		fit$model$M <- Mv
	fit$call <- call
	fit$terms <- Terms
	fit$formula <- as.vector(attr(Terms, "formula"))
	fit$contrasts <- attr(x, "contrasts")
	fit$nobs <- nobs
	fit$iterations <- z$iter
	fit$coefficients <- as.vector(z$estb)
	fit$nas <- is.na(fit$coefficients)
	names(fit$coefficients) <- xnames
	eta <- as.vector(x %*% fit$coefficients)
	fit$linear.predictors <- eta
##Rchange
	mu <- as.vector(family$linkinv(eta))
##
	fit$fitted.values <- mu
	fit$residuals <- y - mu
	fit$family <- family
	fit$y <- as.vector(y)
	fit$id <- as.vector(id)
	fit$max.id <- z$mc
	z$wcor <- matrix(z$wcor, ncol = maxclsz)
	fit$working.correlation <- z$wcor
	fit$scale <- z$sc
	fit$robust.variance <- z$rv
	fit$naive.variance <- z$nv
	fit$xnames <- xnames
	fit$error <- z$err
	dimnames(fit$robust.variance) <- list(xnames, xnames)
	dimnames(fit$naive.variance) <- list(xnames, xnames)
	class(fit)<-c("gee", "glm")
	fit
}
