#SCCS @(#)mdy.date.s	1.2  6/12/91
#  Get the Julian date, but centered a la SAS, i.e., Jan 1 1960 is day 0.
#    Algorithm taken from Numerical Recipies.
#
mdy.date <- function (month, day, year, nineteen=T, fillday=F, fillmonth=F) {
    temp <- any( (month != trunc(month)) | (day != trunc(day)) |
		 (year != trunc(year)))
    if (!is.na(temp) && temp) {
	warning("Non integer input values were truncated in mdy.date")
	month <- trunc(month)
	day <- trunc(day)
	year <- trunc(year)
	}
    if (nineteen)  year <- ifelse(year <100, year+1900, year)

    # Force input vectors to be the same length, but in a way that gives an
    #   error if their lengths aren't multiples of each other.
    temp <- 0*(month + day + year)
    month <- month + temp
    day   <- day + temp
    year  <- year + temp

    if (fillmonth) {
	temp <- is.na(month)
	month[temp] <- 7
	day[temp] <- 1
	}
    if (fillday) day[is.na(day)] <- 15


    month[month<1 | month>12] <- NA
    day[day<1] <- NA
    year[year==0] <- NA     #there is no year 0
    year <- ifelse(year<0, year+1, year)
    tyear<- ifelse(month>2, year, year-1)
    tmon <- ifelse(month>2, month+1, month+13)

    julian <- trunc(365.25*tyear) + trunc(30.6001*tmon) + day - 715940
    # Check for Gregorian calendar changeover on Oct 15, 1582
    temp <- trunc(0.01 * tyear)
    save <- ifelse(julian>=-137774, julian +2 + trunc(.25*temp) - temp, julian)

    #check for invalid days (31 Feb, etc.) by calculating the Julian date of
    #    the first of the next month
    year <- ifelse(month==12, year+1, year)
    month<- ifelse(month==12, 1, month+1)
    day <- 1
    tyear<- ifelse(month>2, year, year-1)
    tmon <- ifelse(month>2, month+1, month+13)
    julian <- trunc(365.25*tyear) + trunc(30.6001*tmon) + day - 715940
    temp <- trunc(0.01 * tyear)
    save2<- ifelse(julian>=-137774, julian +2 + trunc(.25*temp) - temp, julian)
    temp <-as.integer(ifelse(save2>save, save, NA))
    attr(temp, "class") <- "date"
    temp
    }
