% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual_compendium_reference.R
\name{manual_compendium_reference}
\alias{manual_compendium_reference}
\title{Manually Encode Direct Observation Intensities by Cross-Referencing the
\href{https://sites.google.com/site/compendiumofphysicalactivities/}{Compendium
of Physical Activities}}
\usage{
manual_compendium_reference(
  obs_data,
  kids = c("yes", "no"),
  mvpa = c("yes", "no")
)
}
\arguments{
\item{obs_data}{A data frame outputted from
\code{\link{data_collection_program}} with
    \code{interactive = FALSE}}

\item{kids}{A character scalar in \code{c("yes", "no")}:
Should intensities be determined using youth cutoffs for
light intensity (2 metabolic equivalents, not 1.5) and
moderate intensity (4 metabolic equivalents, not 3)
physical activity? Default is \code{"yes"}, with a warning
that the value was not manually set.}

\item{mvpa}{A character scalar in \code{c("yes", "no")}: Should
moderate and vigorous physical activity be coded as a single
category (i.e., MVPA)? Default is \code{"yes"}, with a
warning that the value was not manually set.}
}
\value{
A list with three elements. The first (\code{data}) is the
  original data, where a \code{Final_Intensity} column has been
  populated to the extent possible, with "Indeterminate" listed for
  the other activities. The second element (\code{indeterminate}) is
  another list, which has one element for each activity in
  \code{data} with \code{Final_Intensity = "Indeterminate"}. The
  elements of \code{indeterminate} are named after the activity they
  represent, and the contents are a subset of the Compendium giving
  suggested matches for the activity, based on its description in
  \code{data}. The third element (\code{compendium}) gives the entire
  compendium, which can be manually cross-referenced for cases where
  the suggested matches in \code{indeterminate} do not give a suitable
  match.
}
\description{
Manually Encode Direct Observation Intensities by Cross-Referencing the
\href{https://sites.google.com/site/compendiumofphysicalactivities/}{Compendium
of Physical Activities}
}
\examples{
data(example_data)

example_data_processed <- compendium_reference(example_data, FALSE,
   kids = "yes", mvpa = "yes")

if (interactive()) {
 View(example_data_processed$data)
 View(example_data_processed$indeterminate[[1]])
 View(example_data_processed$compendium)
}

}
\seealso{
Other processing functions: 
\code{\link{compendium_reference}()},
\code{\link{interactive_compendium_reference}()}
}
\concept{processing functions}
\keyword{internal}
