% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeoFunctions.R
\name{distance}
\alias{distance}
\title{A function to compute the distance matrix between centroids 
of spatial units}
\usage{
distance(spatobj = NULL, folder = NULL, shape = NULL,
distin = 'm',  distout = 'm', diagval = '0')
}
\arguments{
\item{spatobj}{a spatial object (class sf, sfc or sfg) containing 
geographic information}

\item{folder}{a character vector with the folder (directory) 
name indicating where the shapefile with the geographic information 
is located.}

\item{shape}{a character vector with the name of the shapefile 
(without the .shp extension) which contains the geographic information}

\item{distin}{input metric conversion, based on  \pkg{measurements} package and 
includes conversions from 'm', 'km', 'inch', 'ft', 'yd', 'mi', 'naut_mi', etc.}

\item{distout}{output metric conversion, based on  \pkg{measurements} package and 
includes conversions to 'm', 'km', 'inch', 'ft', 'yd', 'mi', 'naut_mi', etc.}

\item{diagval}{the user has the choice of the definition of the diagonal: 
diagval = '0'  (by default) for an 'empty' diagonal and diagval = 'a'
to compute  the diagonal as 0.6 * square root (spatial units area) (White, 1983)}
}
\value{
A matrix with the distance between spatial units centroids
}
\description{
The function is based on \pkg{sf} 
package and can be used with a shape file or an R spatial object 
(class sf, sfc or sfg).
}
\examples{
 distance(segdata) 

foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'segdata'
distance(folder = foldername, shape = shapename)
}
\seealso{
Other spatial functions used for segregation indices 
computation: \code{\link{area}}, \code{\link{contig}}, 
\code{\link{perimeter}}, \code{\link{distcenter}}, 
\code{\link{boundaries}}
}
