% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSR.R
\name{MSR}
\alias{MSR}
\title{Mean Residue}
\usage{
MSR(Block)
}
\arguments{
\item{Block}{The sub-matrix block of W, indexed by a row cluster and a column cluster}
}
\value{
The mean residue of the block
}
\description{
To calculate mean residue of a sub-matrix block of W, indexed by a row cluster and a column cluster
}
\examples{

W <- simu_data_generation()
OSNMTF_res <- OSNMTF(W,k=5,l=4)
row_cluster <- OSNMTF_res[[2]][[1]]
column_cluster <- OSNMTF_res[[2]][[2]]
temp_rows <- which(row_cluster==1,TRUE)
temp_cols <- which(column_cluster==1,TRUE)
MSR_value <- MSR(W[temp_rows,temp_cols])
}
\author{
Xiaoyao Yin
}
