% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_hamming.R
\name{nd.hamming}
\alias{nd.hamming}
\title{Hamming Distance}
\usage{
nd.hamming(A, out.dist = TRUE)
}
\arguments{
\item{A}{a list of length \eqn{N} containing adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
}
}
\description{
Hamming Distance is the count of discrepancy between two binary networks for each edge.
Therefore, if used with non-binary networks, it might return a warning message and distorted results.
It was originally designed to compare two strings of equal length, see \href{https://en.wikipedia.org/wiki/Hamming_distance}{Wikipedia page} for more detailed introduction.
}
\examples{
## load example data and extract only a few
data(graph20)
gr.small = graph20[c(1:5,11:15)]

## compute distance matrix
output = nd.hamming(gr.small, out.dist=FALSE)

## visualize
opar = par(no.readonly=TRUE)
par(pty="s")
image(output$D[,10:1], main="two group case", axes=FALSE, col=gray(0:32/32))
par(opar)

}
\references{
\insertRef{hamming_error_1950}{NetworkDistance}
}
