% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{igrepl}
\alias{igrepl}
\title{Perform inverse regex search (C++)}
\usage{
igrepl(patterns, x, fixed = FALSE)
}
\arguments{
\item{patterns}{a character vector of regex or fixed patterns.}

\item{x}{a string to search for the match.}

\item{fixed}{a logical, indicating whether patterns are fixed strings.}
}
\value{
Logical vector of length as \code{patterns} with true if pattern
was found.
}
\description{
This function takes character vector \code{patterns} with regex patterns
(or fixed strings),
and searches for match in the \code{x} string. It is inverse in the meaning,
that in \link[base]{grepl} single pattern is used against multiple strings;
instead, this function takes multiple patterns to fit on a single string.
}
\examples{
igrepl(c("today","b.* fox", "jumps over", "vigorous"),
"The quick brown fox jumps over the lazy dog", FALSE)
igrepl(c("today","brown fox", "jumps over", "vigorous"),
"The quick brown fox jumps over the lazy dog", TRUE)
}
