% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tryCatchAll.R
\name{tryCatchAll}
\alias{tryCatchAll}
\title{Catch errors, warnings, messages}
\usage{
tryCatchAll(expr, message = FALSE, warning = TRUE, error = TRUE)
}
\arguments{
\item{expr}{The expression to catch errors, warnings, messages from}

\item{message}{Catch messages? Default is `FALSE`.}

\item{warning}{Catch warnings? Default is `TRUE`.}

\item{error}{Catch errors? Default is `TRUE`.}
}
\description{
Catch errors, warnings, messages
}
\examples{
testfun <- function(x) {
    message("Starting function")
    if (x == 0) warning("x is zero")
    if (x < 0) stop("x is negative")
    message("Ending function")
    x
}

## use the class of the result to test whether anything was
## caught.
res1 <- NMdata:::tryCatchAll(testfun(1))  
res1
inherits(res1,"tryCatchAll")
res1b <- NMdata:::tryCatchAll(testfun(1),message=FALSE)  
res1b
inherits(res1b,"tryCatchAll")

res2 <- NMdata:::tryCatchAll(testfun(0))  
res2
inherits(res2,"tryCatchAll")

res3 <- NMdata:::tryCatchAll(testfun(-1)) 
res3
inherits(res3,"tryCatchAll")
}
\keyword{internal}
