% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SubsetData.R
\name{SubsetData}
\alias{SubsetData}
\title{Create a subset of data}
\usage{
SubsetData(data, x, x.cat, include = TRUE)
}
\arguments{
\item{data}{Data, structured in a dataframe}

\item{x}{Variable(s) used to subset the data}

\item{x.cat}{Specific criteria (value(s)) of \code{x} used to subset the data}

\item{include}{Include/exclude value specified in \code{x.cat}. If
\code{include = TRUE} (default value), then observations with
\code{x} = \code{x.cat} are selected. If \code{include = FALSE}, then
observations with value specified in \code{x.cat} will be omitted from the
subset of the data.}
}
\value{
This function returns a subset of data
}
\description{
This function creates a subset of dataset according to specified criteria.
}
\details{
\itemize{
\item{If there are several variable \code{x} used as criteria to subset the
data, \code{x.cat} can be written as \code{list(... , ...)}}
\item{Values in \code{x.cat} should be specified in the same order as the
\code{x}'s}
}
}
\examples{

# Create data of NM-400 (Multi-walled carbon nanotubes) from geninvitro dataset
data.sub<-SubsetData(data=geninvitro, x="name",
x.cat="NM-400 (Multi-walled carbon nanotubes)", include = TRUE)

# Create data of NM-400 (Multi-walled carbon nanotubes)
# with DNA STRAND BREAKS as the endpoint from geninvitro dataset
data.sub<-SubsetData(data=geninvitro, x=c("name","endpoint"),
x.cat=list("NM-400 (Multi-walled carbon nanotubes)","DNA STRAND BREAKS"),
include=TRUE)

# Exclude NM-400 (Multi-walled carbon nanotubes) from geninvitro dataset
data.sub<-SubsetData(data=geninvitro, x="name",
x.cat="NM-400 (Multi-walled carbon nanotubes)", include = FALSE)

# Create data of NM-400 (Multi-walled carbon nanotubes)
# and NM-110 (Zinc Oxide, uncoated) from geninvitro dataset
data.sub<-SubsetData(data=geninvitro, x="name",
x.cat=c("NM-400 (Multi-walled carbon nanotubes)",
"NM-110 (Zinc Oxide, uncoated)"), include = TRUE)

# Create data of NM-400 (Multi-walled carbon nanotubes)
# and NM-110 (Zinc Oxide, uncoated), with DNA STRAND BREAKS as the endpoint
data.sub<-SubsetData(data=geninvitro, x=c("name","endpoint"),
x.cat=list(c("NM-400 (Multi-walled carbon nanotubes)",
"NM-110 (Zinc Oxide, uncoated)"),"DNA STRAND BREAKS"),include = TRUE)

# Create a new dataset containing only control values from geninvitro dataset
controldata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
"medium", "medium + BSA", "untreated"))
}
