% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmmipw.R
\name{nmm_fit}
\alias{nmm_fit}
\title{Fitting IPW or AIPW Estimators under Nonmonotone Missing at Random Data}
\usage{
nmm_fit(
  data,
  O,
  AIPW = FALSE,
  formula = NULL,
  func = NULL,
  weights = NULL,
  ...
)
}
\arguments{
\item{data}{a data.frame to fit}

\item{O}{missing indicator}

\item{AIPW}{indicator if fitting augmented IPW}

\item{formula}{optional formula specified to fit}

\item{func}{optional fitting function, currently support 'lm' and 'glm'}

\item{weights}{optional weights used in the estimation}

\item{...}{further arguments passed to func, e.g. family = 'quasibinomial' for glm}
}
\value{
NMMIPW returns an object of class "NMMIPW".
An object of class "NMMIPW" is a list containing the following components:
\item{coefficients}{the fitted values, only reported when formula and func are given}
\item{coef_sd}{the standard deviations of coefficients, only reported when formula and func are given}
\item{coef_IF}{the influnece function of coefficients, only reported when formula and func are given}
\item{gamma_para}{the first step fitted valus}
\item{AIPW}{an indicator of whether AIPW is fitted}
\item{second_step}{an indicator of whether the second step is fitted}
\item{second_fit}{if second step fitted, we report the fit object}
\item{by_prod}{a list of by products that might be useful for users, including first step IF, jacobian matrices}
}
\description{
nmm_fit is the main function used to fit IPW or AIPW estimators under nonmonotone missing at random data
}
\examples{
n = 100
X = rnorm(n, 0, 1)
Y = rnorm(n, 1 * X, 1)
O1 = rbinom(n, 1, 1/(1 + exp(- 1 - 0.5 * X)))
O2 = rbinom(n, 1, 1/(1 + exp(+ 0.5 + 1 * Y)))
O = cbind(O1, O2)
df <- data.frame(Y = Y, X = X)
fit <- nmm_fit(data = df, O = O, formula = Y ~ X, func = lm)
}
