\name{trans.armdata}
\alias{trans.armdata}
\title{Transforming contrast-based summary statistics to arm-based data}
\usage{
trans.armdata(study,treat1,treat2,n1,n2,y,SE,measure,data)
}
\arguments{
\item{study}{Study ID}
\item{treat1}{Treatment variable of arm 1. It can be formed as both of numbered treatment (=1,2,...) and characters (e.g., "Placebo", "ARB", "Beta blocker").}
\item{treat2}{Treatment variable of arm 2. It can be formed as both of numbered treatment (=1,2,...) and characters (e.g., "Placebo", "ARB", "Beta blocker").}
\item{n1}{Sample size of arm 1.}
\item{n2}{Sample size of arm 2.}
\item{y}{Contrast-based summary statistics (e.g., estimate of \code{logHR} between arms 1 and 2).}
\item{SE}{Standard error estimate of \code{y}.}
\item{measure}{Outcome measure (can be \code{logOR} (log odds ratio), \code{logRR} (log risk ratio), and \code{RD} (risk difference) for dichotomous outcome, \code{MD} (mean difference) for continuous outcome, and \code{logHR} (log hazard ratio) for survival outcome.}
\item{data}{A data frame that involves the contrast-based data.}
}
\value{
Estimated arm-based summary statistics are generated. Note the estimated data may not accord to the original data. However, they are solely pseudo-data, designed so that the contrast-based statistics generated by the \code{setup} function accord to the original data. The \code{NMA} package tools rely solely on summary statistics for the synthesis analyses, so this is not problematic.
\itemize{
\item \code{study}: The ID variable that specifies studies.
\item \code{trt}: A variable that specifies treatment categories.
\item \code{d}: The estimated number of events (possibly pseudo-data; for dichotomous and survival outcomes).
\item \code{n}: The sample sizes.
\item \code{m}: The estimated means (possibly pseudo-data; for continuous outcomes).
\item \code{s}: The estimated SDs (possibly pseudo-data; for continuous outcomes).
}
}
\description{
The multivariate meta-analysis and meta-regression models used in \code{NMA} package require contrast-based summary statistics created by \code{setup} function. 
The \code{setup} function requires arm-based data for individual studies. 
Some studies only report summary statistics (e.g., hazard ratio estimates) and do not provide arm-level data. 
The \code{trans.armdata} function creates arm-level data that can be used for the \code{setup} function using the summary statistics.  
Note the estimated data may not accord to the original data. 
However, they are solely pseudo-data, designed so that the contrast-based statistics generated by the \code{setup} function accord to the original data. 
The \code{NMA} package tools rely solely on summary statistics for the synthesis analyses, so this is not problematic. 
If there are relevant covariate data that can used for meta-regression analyses, please edit the output object before entering to the \code{setup} function; the output object can be exported to a CSV or Microsoft Excel file. 
Also, when some studies report only arm-level data, users can combine the data object of arm-based data with the output object of \code{trans.armdata} function.
For hazard ratio estimates, the event number is inversely calculated using the complementary log-log-type estimator. 
}
\references{
Noma, H. and Maruo, K. (2025). Network meta-analysis combining survival and count outcome data: A simple frequentist approach. medRxiv, \doi{https://doi.org/10.1101/2025.01.23.25321051}.
}
\examples{
data(exdataMD)
trans.armdata(study=id,treat1=treat1,treat2=treat2,n1=n1,n2=n2,y=MD,SE=seMD,
measure="MD",data=exdataMD)

data(exdataRR)
trans.armdata(study=id,treat1=treat1,treat2=treat2,n1=n1,n2=n2,y=logRR,SE=SE,
measure="logRR",data=exdataRR)

data(woods1)
trans.armdata(study=studlab,treat1=treat1,treat2=treat2,n1=n1,n2=n2,y=TE,SE=seTE,
measure="logHR",data=woods1)
# Event numbers are invesely calculated by the hazard ratio estimates.
# The resultant event numbers can differ from the actual event numbers,
# but they can be interpreted as pseudo-data that have equivalent information
# with the hazard ratio estimates.
# The hazard ratio estimates can be re-calculated by setup function.
}
