% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_scaling.R
\name{create_nmar_scaling_recipe}
\alias{create_nmar_scaling_recipe}
\title{Build a scaling recipe from one or more design matrices}
\usage{
create_nmar_scaling_recipe(
  ...,
  intercept_col = "(Intercept)",
  weights = NULL,
  weight_mask = NULL,
  tol_constant = 1e-08,
  warn_on_constant = TRUE
)
}
\arguments{
\item{...}{One or more numeric matrices with column names.}

\item{intercept_col}{Name of an intercept column that should remain unscaled.}

\item{weights}{Optional nonnegative numeric vector used to compute weighted
means and standard deviations.}

\item{weight_mask}{Optional logical mask or nonnegative numeric multipliers
applied to \code{weights} before computing moments (useful for
respondents-only scaling). If \code{weights} is \code{NULL},
\code{weight_mask} is treated as weights.}

\item{tol_constant}{Numeric tolerance below which columns are treated as
constant and left unscaled.}

\item{warn_on_constant}{Logical; warn when a column is treated as constant.}
}
\description{
Build a scaling recipe from one or more design matrices
}
\keyword{internal}
