% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCmisc.R
\name{table2d}
\alias{table2d}
\title{Wrapper for the base table() function that includes
zero counts - useful to get consistent dimensions across
multiple runs with different responding patterns
Forces a 2d table with every possible cell (allow zero counts)
Only for tables where there are two vectors entered, while
the base function allows for more, or also allows just 1.
If the wrong arguments are entered, attempts to pass the input
to the base version of 'table' instead.}
\usage{
table2d(
  ...,
  col,
  row,
  rn = NULL,
  cn = NULL,
  use.order = TRUE,
  remove.na = FALSE
)
}
\arguments{
\item{...}{vector arguments, see input for base:table() function}

\item{col}{categories to include as columns of the table}

\item{row}{categories to include as rows of the table}

\item{rn}{optionally replace the raw value names with desired row names.
Must be same length as 'row'.}

\item{cn}{optionally replace the raw value names with desired column names.
Must be same length as 'col'.}

\item{use.order}{TRUE to use the order in 'col' and 'row' for table, otherwise
use the default order of table() - which is usually alphabetical}

\item{remove.na}{remove NA values from row/col if present}
}
\value{
returns a table, just like the base:table() function
but the row and column names are fixed regardless of count
}
\description{
Wrapper for the base table() function that includes
zero counts - useful to get consistent dimensions across
multiple runs with different responding patterns
Forces a 2d table with every possible cell (allow zero counts)
Only for tables where there are two vectors entered, while
the base function allows for more, or also allows just 1.
If the wrong arguments are entered, attempts to pass the input
to the base version of 'table' instead.
}
\examples{
nm <- c("Mike", "Anna", "John", "Tony")
vec_r <- sample(tolower(nm)[c(1,3,4)], 50, replace=TRUE)
vec_c <- sample(c(1,2,4,5), 50, replace=TRUE)
table(vec_r, vec_c)
table2d(vec_r, vec_c, row=tolower(nm), col=paste(1:5))
table2d(vec_r, vec_c, row=tolower(nm), col=paste(1:5), use.order = FALSE)
table2d(vec_r, vec_c, row=tolower(nm), col=paste(1:5), rn=nm, cn=c("I", "II", "III", "IV", "V"))
}
\author{
Nicholas Cooper
}
