% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NADA_icmle.R
\name{EM}
\alias{EM}
\title{EM Algorithm for Interval-Censored Data}
\usage{
EM(A, pvec, maxiter = 500, tol = 1e-12)
}
\arguments{
\item{A}{Either a logical matrix or an interval matrix (n x 2).}

\item{pvec}{Optional initial probability vector.}

\item{maxiter}{Maximum number of EM iterations (default 500).}

\item{tol}{Convergence tolerance (default 1e-12).}
}
\value{
An object of class \code{"icsurv"} with elements:
\describe{
\item{pf}{Estimated probability mass function}
\item{numiter}{Number of iterations}
\item{converge}{Logical, whether EM converged}
\item{intmap}{Interval map (if applicable)}
}
}
\description{
EM Algorithm for Interval-Censored Data
}
