% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallFcts.R
\name{HermiteN}
\alias{HermiteN}
\title{Hermite Polynomials (Univariate and Multivariate)}
\usage{
HermiteN(x, N, Type, sigma2 = 1, Sig2 = diag(length(x)))
}
\arguments{
\item{x}{A scalar (for univariate) or a vector (for multivariate) at which to evaluate the Hermite polynomials.}

\item{N}{The maximum order of the polynomials.}

\item{Type}{A character string specifying the type of Hermite polynomials to compute. Can be either "Univariate" or "Multivariate".}

\item{sigma2}{The variance for univariate Hermite polynomials. Default is 1. (Only used if Type is "Univariate").}

\item{Sig2}{The covariance matrix for multivariate Hermite polynomials. Default is the unit matrix diag(length(x)). (Only used if Type is "Multivariate").}
}
\value{
Depending on the type, the function returns:
\itemize{
  \item \code{Univariate}: A vector of univariate Hermite polynomials with degrees from 1 to N evaluated at x.
  \item \code{Multivariate}: A list of multivariate polynomials of order from 1 to N evaluated at vector x.
}
}
\description{
Computes either univariate or multivariate Hermite polynomials up to a specified order.
}
\details{
Depending on the value of the `Type` parameter, this function computes either the univariate or the multivariate Hermite polynomials.
}
\examples{
# Univariate example
HermiteN(x = 1, N = 3, Type = "Univariate")

# Multivariate example
HermiteN(x = c(1, 3), N = 3, Type = "Multivariate", Sig2 = diag(2))

}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear, Springer 2021. Section 4.1 (for univariate), Section 4.6.2, (4.73), p.223 (for multivariate).
}
\seealso{
Other Hermite Polynomials: 
\code{\link{HermiteCoeff}()},
\code{\link{HermiteCov12}()},
\code{\link{HermiteN2X}()}
}
\concept{Hermite Polynomials}
