% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCDA.R
\name{DCDA}
\alias{DCDA}
\title{Diagonal Canonical Discriminant Analysis (DCDA)}
\usage{
DCDA(formula, design, responses, term)
}
\arguments{
\item{formula}{A formula with no left term that specify the model from the elements of the \strong{design} argument.}

\item{design}{A data.frame that contains only factors specifying the design on which rely the specified model of \strong{formula} argument.}

\item{responses}{A matrix or data.frame that contains only numerics or integers being the responses variables to be explained by the model from \strong{formula}.}

\item{term}{A character specifying the term from \strong{formula} for which the MultLSD tests must be performed.}
}
\value{
Returns a list of the following elements:\cr

\item{scores}{A data.frame giving the scores of the individuals of the diagonal canonical variates.}

\item{eigen}{A matrix giving the eigenvalues, corresponding percentages of inertia and cumulative percentages of inertia of the DCDA.}

\item{level.coord}{A matrix giving the coordinates of the levels of the \strong{term} on the diagonal canonical variates.}

\item{var.coord}{A matrix giving the coordinates of the variables of the on the diagonal canonical variates.}

\item{raw.coef}{A matrix giving the raw diagonal canonical coefficients.}

\item{error}{A list containing several information relative to the error. Most of this information are used to compute the approximate ellipses when calling \code{\link[MultANOVA]{plot.DCDA}}.}

\item{svd}{Results of the svd of the weighted orthogonalized effect matrix of \strong{term}.}
}
\description{
Performs the Diagonal Canonical Discriminant Analysis of a term from the model defined by \strong{formula} as defined in Mahieu & Cariou (2025).
}
\examples{
data(OTU)
acd=DCDA(~Lot+Atm+Time,OTU[,1:4],OTU[,-c(1:4)],"Time")
lsd=MultLSD(~Lot+Atm+Time,OTU[,1:4],OTU[,-c(1:4)],"Time")
fish=FisherS(~Lot+Atm+Time,OTU[,1:4],OTU[,-c(1:4)],"Time")
plot(acd,axes = c(1,2),pair.comp = lsd,expansion.var = 1.5,select.var = which(fish[2,]<=0.05))
}
\references{
Mahieu, B., & Cariou, V. (2025). MultANOVA Followed by Post Hoc Analyses for Designed High‐Dimensional Data: A Comprehensive Framework That Outperforms ASCA, rMANOVA, and VASCA. Journal of Chemometrics, 39(7). \doi{https://doi.org/10.1002/cem.70039}

Dudoit, S., Fridlyand, J., & Speed, T. P. (2002). Comparison of Discrimination Methods for the Classification of Tumors Using Gene Expression Data. Journal of the American Statistical Association, 97(457), 77–87. \doi{https://doi.org/10.1198/016214502753479248}
}
