% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equidistantCurve.r
\name{equidistantCurve}
\alias{equidistantCurve}
\title{make a curve equidistant (optionally up/downsampling)}
\usage{
equidistantCurve(
  x,
  n = NULL,
  open = TRUE,
  subsample = 0,
  increment = 2,
  smoothit = 0,
  mesh = NULL,
  iterations = 1
)
}
\arguments{
\item{x}{k x m matrix containing the 2D or 3D coordinates}

\item{n}{integer: number of coordinates to sample. If NULL, the existing curve will be made equidistant.}

\item{open}{logical: specifies whether the curve is open or closed.}

\item{subsample}{integer: number of subsamples to draw from curve for interpolation. For curves with < 1000 points, no subsampling is required.}

\item{increment}{integer: if > 1, the curve is estimated iteratively by incrementing the original points by this factor. The closer this value to 1, the smoother the line but possibly farther away from the control points.}

\item{smoothit}{integer: smoothing iterations after each step}

\item{mesh}{specify mesh to project point to}

\item{iterations}{integer: how many iterations to run equidistancing.}
}
\value{
matrix containing equidistantly placed points
}
\description{
make a curve equidistant (optionally up/downsampling)
}
\details{
Equidistancy is reached by iteratively deforming (using TPS) a straight line with equidistantly placed points to the target using control points with the same spacing as the actual curve. To avoid singularity, the straight line containes a small amount of noise, which can (optionally) be accounted for by smoothing the line by its neighbours.
}
\note{
if n >> number of original points, the resulting curves can show unwanted distortions.
}
\examples{
\dontrun{
data(nose)
x <- shortnose.lm[c(304:323),]
xsample <- equidistantCurve(x,n=50,iterations=10,increment=2)

require(rgl)
points3d(xsample,size=5)
spheres3d(x,col=2,radius=0.3,alpha=0.5)
}
}
