% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorize.R
\name{categorize}
\alias{categorize}
\title{Generates Categorical Data Sets from Continuous Data.}
\usage{
categorize(f.loc, threshold, dataList = "Data_List.dat")
}
\arguments{
\item{f.loc}{A character string indicating the file path where the generated categorical data sets will be saved.}

\item{threshold}{A numeric vector specifying the threshold values used to discretize the continuous data into ordered categories.}

\item{dataList}{A character string giving the name of the file that contains the list of previously generated data sets.}
}
\description{
This function transforms previously simulated continuous data sets into categorical variables based on user-specified threshold values.
The function reads in existing data sets, applies the thresholding procedure to discretize the observed scores, and saves the resulting categorical
data sets into the designated file location. Additionally, it produces an updated list of the newly created categorical data sets for future reference.
}
\examples{
tres<-c(-Inf, -1.645, -.643, .643, 1.645, Inf) # five categories
categorize(f.loc=tempdir(), threshold = tres)
}
\author{
Fatih Orçan
}
