% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ais}
\alias{ais}
\title{Australian Institute of Sport data}
\format{
A data frame with 202 observations on the following 13 variables:
\describe{
\item{\code{sex}}{categorical, levels = \code{female, male}}
\item{\code{sport}}{categorical, levels = \code{B_Ball, Field, Gym, Netball, Row, Swim, T_400m, Tennis, T_Sprnt, W_Polo}}
\item{\code{RCC}}{red cell count (numeric)}
\item{\code{WCC}}{white cell count (numeric)}
\item{\code{Hc}}{Hematocrit (numeric)}
\item{\code{Hg}}{Hemoglobin (numeric)}
\item{\code{Fe}}{plasma ferritin concentration (numeric)}
\item{\code{BMI}}{body mass index: \code{Wt/(Ht)^2} (numeric)}
\item{\code{SSF}}{sum of skin folds (numeric)}
\item{\code{Bfat}}{body fat percentage (numeric)}
\item{\code{LBM}}{lean body mass (numeric)}
\item{\code{Ht}}{height, cm (numeric)}
\item{\code{Wt}}{weight, kg (numeric)}
}
}
\usage{
data(ais)
}
\description{
Data on 102 male and 100 female athletes collected at the Australian Institute of Sport, courtesy of Richard Telford and Ross Cunningham.
}
\details{
The data have been made publicly available in connection with the book by Cook and Weisberg (1994).
}
\examples{
data(ais, package="MoEClust")
pairs(ais[,c(3:7)], col=as.numeric(ais$sex), main = "AIS data")
apply(ais[,c(3:7)], 2, summary)
}
\references{
Cook, R. D. and Weisberg, S. (1994), \emph{An Introduction to Regression Graphics}. Volume 405 of \emph{Wiley Series in Probability and Statistics}, New York, NY, USA: John Wiley & Sons.
}
\keyword{datasets}
