% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{drop_levels}
\alias{drop_levels}
\title{Drop unused factor levels to predict from unseen data}
\usage{
drop_levels(fit,
            newdata)
}
\arguments{
\item{fit}{A fitted \code{\link[stats]{lm}} or \code{\link[nnet]{multinom}} model.}

\item{newdata}{A \code{data.frame} containing variables with which to predict.}
}
\value{
A \code{data.frame} like \code{newdata} with unseen factor levels replaced by \code{NA}.
}
\description{
Drops unseen factor levels in \code{newdata} for which predictions are required from a \code{\link[stats]{lm}} or \code{\link[nnet]{multinom}} model \code{fit}.
}
\note{
This function is so far untested for models other than \code{\link[stats]{lm}} or \code{\link[nnet]{multinom}}, though it \emph{may} still work for other classes.
}
\examples{
data(ais)
hema  <- as.matrix(ais[,3:7])
BMI   <- ais$BMI
sport <- ais$sport
sub   <- ais$sport != "Row"

# Fit a linear model
mod   <- lm(hema ~ BMI + sport, data=ais, subset=sub)

# Make predictions
pred1 <- try(predict(mod, newdata=ais), silent=TRUE)
inherits(pred1, "try-error") #TRUE

# Remove unused levels and try again
pred2 <- try(predict(mod, newdata=drop_levels(mod, ais)), silent=TRUE)
inherits(pred2, "try-error") #FALSE
anyNA(pred2)                 #TRUE
}
\seealso{
\code{\link{drop_constants}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@mu.ie}>
}
\keyword{utility}
