% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creating.trait.R
\name{creating.trait}
\alias{creating.trait}
\title{Generation of genomic traits}
\usage{
creating.trait(
  population,
  trait.name = NULL,
  mean.target = NULL,
  var.target = NULL,
  qtl.position.shared = FALSE,
  trait.cor = NULL,
  trait.cor.include = NULL,
  n.additive = 0,
  n.equal.additive = 0,
  n.dominant = 0,
  n.equal.dominant = 0,
  n.overdominant = 0,
  n.equal.overdominant = 0,
  n.qualitative = 0,
  n.quantitative = 0,
  effect.distribution = "gauss",
  gamma.shape1 = 1,
  gamma.shape2 = 1,
  real.bv.add = NULL,
  real.bv.mult = NULL,
  real.bv.dice = NULL,
  n.traits = 0,
  base.bv = NULL,
  new.residual.correlation = NULL,
  new.breeding.correlation = NULL,
  is.maternal = NULL,
  is.paternal = NULL,
  fixed.effects = NULL,
  trait.pool = 0,
  gxe.correlation = NULL,
  n.locations = NULL,
  gxe.max = 0.85,
  gxe.min = 0.7,
  location.name = NULL,
  gxe.combine = TRUE,
  dominant.only.positive = FALSE,
  exclude.snps = NULL,
  var.additive.l = NULL,
  var.dominant.l = NULL,
  var.overdominant.l = NULL,
  var.qualitative.l = NULL,
  var.quantitative.l = NULL,
  effect.size.equal.add = 1,
  effect.size.equal.dom = 1,
  effect.size.equal.over = 1,
  polygenic.variance = 100,
  bve.mult.factor = NULL,
  bve.poly.factor = NULL,
  set.zero = FALSE,
  bv.standard = FALSE,
  replace.traits = FALSE,
  remove.invalid.qtl = TRUE,
  randomSeed = NULL,
  verbose = TRUE,
  use.recalculate.manual = NULL,
  new.phenotype.correlation = NULL,
  shuffle.traits = NULL,
  shuffle.cor = NULL,
  bv.total = 0
)
}
\arguments{
\item{population}{Population list}

\item{trait.name}{Name of the trait generated}

\item{mean.target}{Target mean}

\item{var.target}{Target variance}

\item{qtl.position.shared}{Set to TRUE to put QTL effects on the same markers for different traits}

\item{trait.cor}{Target correlation between QTL-based traits (underlying true genomic values)}

\item{trait.cor.include}{Vector of traits to be included in the modelling of correlated traits (default: all - needs to match with trait.cor)}

\item{n.additive}{Number of additive QTL with effect size drawn from a gaussian distribution}

\item{n.equal.additive}{Number of additive QTL with equal effect size (effect.size)}

\item{n.dominant}{Number of dominant QTL with effect size drawn from a gaussian distribution}

\item{n.equal.dominant}{Number of dominant QTL with equal effect size}

\item{n.overdominant}{Number of overdominant QTL with effect size drawn from absolute value of a gaussian distribution}

\item{n.equal.overdominant}{Number of overdominant QTL with equal effect size}

\item{n.qualitative}{Number of qualitative epistatic QTL}

\item{n.quantitative}{Number of quantitative epistatic QTL}

\item{effect.distribution}{Set to "gamma" for gamma distribution effects with gamma.shape1, gamma.shape2 instead of gaussian (default: "gauss")}

\item{gamma.shape1}{Default: 1}

\item{gamma.shape2}{Default: 1}

\item{real.bv.add}{Single Marker effects}

\item{real.bv.mult}{Two Marker effects}

\item{real.bv.dice}{Multi-marker effects}

\item{n.traits}{Number of traits (If more than traits via real.bv.X use traits with no directly underlying QTL)}

\item{base.bv}{Average genetic value of a trait}

\item{new.residual.correlation}{Correlation of the simulated enviromental variance}

\item{new.breeding.correlation}{Correlation of the simulated genetic variance (child share! heritage is not influenced!}

\item{is.maternal}{Vector coding if a trait is caused by a maternal effect (Default: all FALSE)}

\item{is.paternal}{Vector coding if a trait is caused by a paternal effect (Default: all FALSE)}

\item{fixed.effects}{Matrix containing fixed effects (p x k -matrix with p being the number of traits and k being number of fixed effects; default: p x 1 matrix with 0s (additional intercept))}

\item{trait.pool}{Vector providing information for which pools QTLs of this trait are activ (default: 0 - all pools)}

\item{gxe.correlation}{Correlation matrix between locations / environments (default: only one location, sampled from gxe.max / gxe.min)}

\item{n.locations}{Number of locations / environments to consider for the GxE model}

\item{gxe.max}{Maximum correlation between locations / environments when generating correlation matrix via sampling (default: 0.85)}

\item{gxe.min}{Minimum correlation between locations / environments when generating correlation matrix via sampling (default: 0.70)}

\item{location.name}{Same of the different locations / environments used}

\item{gxe.combine}{Set to FALSE to not view the same trait from different locations / environments as the sample trait in the prediction model (default: TRUE)}

\item{dominant.only.positive}{Set to TRUE to always assign the heterozygous variant with the higher of the two homozygous effects (e.g. hybrid breeding); default: FALSE}

\item{exclude.snps}{Marker were no QTL are simulated on}

\item{var.additive.l}{Variance of additive QTL}

\item{var.dominant.l}{Variance of dominante QTL}

\item{var.overdominant.l}{Variance of overdominante QTL}

\item{var.qualitative.l}{Variance of qualitative epistatic QTL}

\item{var.quantitative.l}{Variance of quantitative epistatic QTL}

\item{effect.size.equal.add}{Effect size of the QTLs in n.equal.additive}

\item{effect.size.equal.dom}{Effect size of the QTLs in n.equal.dominant}

\item{effect.size.equal.over}{Effect size of the QTLs in n.equal.overdominant}

\item{polygenic.variance}{Genetic variance of traits with no underlying QTL}

\item{bve.mult.factor}{Multiplicate trait value times this}

\item{bve.poly.factor}{Potency trait value over this}

\item{set.zero}{Set to TRUE to have no effect on the 0 genotype (or 00 for QTLs with 2 underlying SNPs)}

\item{bv.standard}{Set TRUE to standardize trait mean and variance via bv.standardization()}

\item{replace.traits}{If TRUE delete the simulated traits added before}

\item{remove.invalid.qtl}{Set to FALSE to deactive the automatic removal of QTLs on markers that do not exist}

\item{randomSeed}{Set random seed of the process}

\item{verbose}{Set to FALSE to not display any prints}

\item{use.recalculate.manual}{Set to TRUE to use recalculate.manual to calculate genomic values (all individuals and traits jointly, default: FALSE)}

\item{new.phenotype.correlation}{(OLD! - use new.residual.correlation) Correlation of the simulated enviromental variance}

\item{shuffle.traits}{OLD! Use trait.cor.include - Vector of traits to be included for modelling of correlated traits (default: all - needs to match with shuffle.cor)}

\item{shuffle.cor}{OLD! Use trait.cor - Target Correlation between traits}

\item{bv.total}{OLD! Use n.traits instead. Number of traits (If more than traits via real.bv.X use traits with no directly underlying QTL)}
}
\value{
Population-list with one or more additional new traits
}
\description{
Generation of the trait in a starting population
}
\examples{
population <- creating.diploid(nsnp=1000, nindi=100)
population <- creating.trait(population, n.additive=100)
}
