% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QualRSD.R
\name{QualRSD}
\alias{QualRSD}
\title{Second Order RSDs with qualitative factors}
\usage{
QualRSD(v, k, Interaction = FALSE)
}
\arguments{
\item{v}{Total number of input factors}

\item{k}{Number of qualitative factors, 1<=k<=v-2}

\item{Interaction}{To specify whether to generate a design for fitting second order model which include Interaction term between qualitative and quantitative factors. The interaction = T means the generated designs will be suitable to fit a second order model which include interaction between qualitative factors and the linear terms of quantitative factors}
}
\value{
Second Order RSDs with qualitative factors along with D-efficiency and G-efficiency
}
\description{
Generate a Second Order Design where first v-k column represent v-k quantitative factors and the last k column represents the k qualitative factors (1<=k<=v-2). It also gives D-efficiency and G-efficiency for the generated design.
}
\examples{
library(MixedLevelRSDs)
QualRSD(5,2, Interaction = FALSE )
}
\references{
1)	M. Hemavathi, Shashi Shekhar, Eldho Varghese, Seema Jaggi, Bikas Sinha & Nripes Kumar Mandal (2022)<doi: 10.1080/03610926.2021.1944213>."Theoretical developments in response surface designs: an informative review and further thoughts".

 2)	Jyoti Divecha and Bharat Tarapara (2017). < doi:10.1080/08982112.2016.1217338>. "Small, balanced, efficient, optimal, and near rotatable response surface designs for factorial experiments asymmetrical in some quantitative, qualitative factors".
}
