% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em_methode.R
\name{em_estimate_stable_recursive_ecf}
\alias{em_estimate_stable_recursive_ecf}
\title{EM algorithm for mixture of alpha-stable distributions using recursive ECF}
\usage{
em_estimate_stable_recursive_ecf(data, max_iter = 100, tol = 1e-04)
}
\arguments{
\item{data}{Numeric vector of observations.}

\item{max_iter}{Maximum number of EM iterations.}

\item{tol}{Convergence tolerance on log-likelihood.}
}
\value{
A list with estimated component parameters (\code{alpha}, \code{beta}, \code{gamma}, \code{delta}) and mixture weight (\code{w}).
}
\description{
Performs Expectation-Maximization (EM) to estimate parameters of a two-component
alpha-stable mixture model using recursive kernel smoothing on the empirical characteristic function.
}
