% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_stat.R
\name{summary_stat}
\alias{summary_stat}
\title{Summary statistics from posterior of MixSIAR model}
\usage{
summary_stat(
  combined,
  toprint = "all",
  groupby = "factor",
  meanSD = TRUE,
  quantiles = c(0.025, 0.25, 0.5, 0.75, 0.975),
  savetxt = TRUE,
  filename = "summary_statistics"
)
}
\arguments{
\item{combined}{list, output from \code{\link{combine_sources}} function}

\item{toprint}{vector, which parameters to print? Options are: \code{"p"} to print stats for proportions only (all factors),
\code{"global"} to only print overall proportions, \code{"fac1"} to only print factor 1 proportions, \code{"fac2"} to print
factor 2 proportions. Set = \code{"epsilon"} to print multiplicative error term only.
Default = \code{"all"}, prints stats for all model parameters.}

\item{groupby}{character, group stats by "factor" or "source"? I.e. in wolves example, group proportions by Region 1, Region 2, Region 3
(\code{groupby="factor"}) vs. Deer, Marine Mammals, Salmon (\code{groupby="source"}). Currently only \code{"factor"} is implemented.}

\item{meanSD}{\code{TRUE/FALSE}, print mean and SD for the parameters?}

\item{quantiles}{vector, which quantiles to print. Default = \code{c(0.025, 0.25, 0.5, 0.75, 0.975)}.}

\item{savetxt}{\code{TRUE/FALSE}, save results as .txt file (in working directory)?}

\item{filename}{character, file name to save results as (\code{.txt} will be appended automatically)}
}
\description{
\code{summary_stat} prints and saves summary statistics
}
\examples{
\dontrun{
# first run mantis shrimp example
# combine 6 sources into 2 groups of interest (hard-shelled vs. soft-bodied)
#   'hard' = 'clam' + 'crab' + 'snail'           # group 1 = hard-shelled prey
#   'soft' = 'alphworm' + 'brittlestar' + 'fish' # group 2 = soft-bodied prey
combined <- combine_sources(jags.1, mix, source, alpha.prior=alpha, 
                groups=list(hard=c("clam","crab","snail"), soft=c("alphworm","brittlestar","fish")))

summary_stat(combined)
summary_stat(combined, savetxt=FALSE)
summary_stat(combined, meanSD=FALSE)
summary_stat(combined, quantiles=c(.05,.5,.95))
summary_stat(combined, toprint="fac1")
summary_stat(combined, toprint="p")
summary_stat(combined, toprint="global")
}
}
\seealso{
\code{\link{combine_sources}} and \code{\link{plot_intervals}}
}
