% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixtureOptim.R
\name{mixtureOptim}
\alias{mixtureOptim}
\title{Performs a full interval optimization}
\usage{
mixtureOptim(
  functions,
  desirabilityModel,
  xCount,
  step = 0.01,
  plot = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{functions}{An array of functions}

\item{desirabilityModel}{A desirability \code{overallD} model}

\item{xCount}{The amount of \code{x} variables used in the functions}

\item{step}{The ammount of each increment in the optimization}

\item{plot}{Define is the data frame that can be used for the \code{desirabilityPlot} function will be create. Strongly affects performance}

\item{verbose}{Defines if the user should be updated with the processing status (percentages)}
}
\value{
A list containg the data regarding the maximum desirability found
}
\description{
This function performs a full interval optimization (0-1 for each \code{x} variable).
It allows the creation of the data frame used for plotting.
}
\examples{
library(MixOptim)
saPred<-function(x) 17.3359 * x[1] + 30.7765 * x[2] + 20.0501 * x[3] + 0.7506 * x[1] * x[2] +
  (-6.3443 * x[1] * x[3]) + (-5.9291 * x[2] * x[3]) +(-25.3093 * x[1] * x[2] * x[3])
pvPred<-function(x)  0.884640 * x[1] + 0.789863 * x[2] + 0.825016 * x[3] +
  (-0.108964 * x[1] * x[2]) + 0.107167 * x[1] * x[3] + (-0.005220 * x[2] * x[3]) +
  1.625246 * x[1] * x[2] * x[3]

funcoes <- c(saPred, pvPred)
saD<-dMin(16.8293856, 31.41170555) #minimun value
pvD<-dMax(0.7796004, 0.9019796) #maximum value
overallD<-dOverall(saD, pvD)

a <- mixtureOptim(funcoes, overallD, 3, step = 0.05, plot = TRUE)
a$bestComposition
# next line will generate a ggplot/patchwork grid
#desirabilityPlot(funcoes, a$plotData, a$bestComposition, list(saD, pvD), c("min", "max"))
}
