% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{assign_dada2}
\alias{assign_dada2}
\title{Assign taxonomy with dada2 using 2 steps assignTaxonomy and assignSpecies}
\usage{
assign_dada2(
  physeq = NULL,
  ref_fasta = NULL,
  seq2search = NULL,
  min_bootstrap = 0.5,
  tryRC = FALSE,
  taxa_ranks = c("Kingdom", "Phylum", "Class", "Order", "Family", "Genus", "Species",
    "taxId"),
  use_assignSpecies = TRUE,
  trunc_absent_ranks = FALSE,
  nproc = 1,
  suffix = "",
  verbose = TRUE,
  seq_at_one_time = 2000,
  allowMultiple = FALSE,
  from_sintax = FALSE
)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{ref_fasta}{(required) A link to a database in fasta.}

\item{seq2search}{A DNAStringSet object of sequences to search for. Replace
the physeq object.}

\item{min_bootstrap}{(Float [0:1], default 0.5), See \code{\link[dada2:assignTaxonomy]{dada2::assignTaxonomy()}}}

\item{tryRC}{See \code{\link[dada2:assignTaxonomy]{dada2::assignTaxonomy()}}}

\item{taxa_ranks}{(vector of character) names for the column of the
taxonomy}

\item{use_assignSpecies}{(logical, default TRUE) Do the Species rank is
obtained using \code{\link[dada2:assignSpecies]{dada2::assignSpecies()}} ?}

\item{trunc_absent_ranks}{(logical, default FALSE) Do ranks present in
taxa_ranks but not present in the database are removed ?}

\item{nproc}{(Float [0:1], default 0.5)}

\item{suffix}{(character) The suffix to name the new columns.
Default to "_idtaxa".}

\item{verbose}{(logical). If TRUE, print additional information.}

\item{seq_at_one_time}{How many sequences are treated at one time.
See param \code{n} in \code{\link[dada2:assignSpecies]{dada2::assignSpecies()}}}

\item{allowMultiple}{(logical, default FALSE). Unchanged from
\code{\link[dada2:assignSpecies]{dada2::assignSpecies()}}.
Defines the behavior when multiple exact matches
against different species are returned. By default only unambiguous
identifications are return. If TRUE, a concatenated string of all
exactly matched species is returned. If an integer is provided,
multiple identifications up to that many are returned as
a concatenated string.}

\item{from_sintax}{(logical, default FALSE). Set to TRUE
if the ref_fasta database is in sintax format. See \code{\link[=assign_sintax]{assign_sintax()}}
for more information about the sintax format.}
}
\value{
Either a an object of class phyloseq (if \code{physeq} is not NULL),
or a taxonomic table if \code{seq2search} is used in place of \code{physeq}
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Mainly a wrapper of \code{\link[dada2:assignTaxonomy]{dada2::assignTaxonomy()}} and \code{\link[dada2:assignSpecies]{dada2::assignSpecies()}}
}
\examples{
\dontrun{
data_fungi_mini2 <- assign_dada2(data_fungi_mini,
  ref_fasta = system.file("extdata", "mini_UNITE_fungi.fasta.gz",
    package = "MiscMetabar"
  ), suffix = "_dada2",
  from_sintax = TRUE
)
}
}
