% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.checkMicrobialGrowthArgs}
\alias{.checkMicrobialGrowthArgs}
\title{Check MicrobialGrowth arguments (regression function)}
\usage{
.checkMicrobialGrowthArgs(
  x,
  y,
  clip,
  start,
  lower,
  upper,
  nls.args,
  callbackError
)
}
\arguments{
\item{x}{index series or time series.}

\item{y}{values or list of values to regress (should not be logged).}

\item{clip}{a pair of values indicating in which interval to clip the data \code{y}. When \code{clip} is missing, default values are used.}

\item{start}{a named list of starting estimates. When \code{start} is missing, default values are used.}

\item{lower}{a named list of lower bounds. When \code{lower} is missing, default values are used.}

\item{upper}{a named list of upper bounds. When \code{upper} is missing, default values are used.}

\item{nls.args}{additional parameters to use when calling \link[stats]{nls}.}

\item{callbackError}{function to call on error during regression.}
}
\value{
the modified \code{clip} value and raises an error if something is wrong.
}
\description{
Check the arguments passed to the regression function.
Tests are generic for all models. For example, the same length for x and y, the type of the
different arguments, the values inserted in \code{start}, \code{lower} and \code{upper}, etc. are tested
}
\details{
During the check, the \code{clip} value is also updated. If the lower bound of \code{clip} is \code{-Inf} (default value), then this value is replaced by the smallest value greater than zero found in \code{y}.
}
