% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryStatistics.R
\name{compare_CherryFreqs}
\alias{compare_CherryFreqs}
\title{Compare Methylation Frequencies Between Two Tips}
\usage{
compare_CherryFreqs(tip1, tip2, testing = FALSE)
}
\arguments{
\item{tip1}{A numeric vector representing methylation states (\code{0}, \code{0.5}, \code{1}) at tip 1.}

\item{tip2}{A numeric vector representing methylation states (\code{0}, \code{0.5}, \code{1}) at tip 2.}

\item{testing}{Logical; if \code{TRUE}, returns additional intermediate data including the contingency table and test result.}
}
\value{
If \code{testing = TRUE}, returns a list with the contingency table and chi-squared test results.
Otherwise, returns the p-value of the test.
}
\description{
Performs a chi-squared test to compare the distribution of methylation states
(unmethylated \code{0}, partially-methylated \code{0.5}, and methylated \code{1})
between two cherry tips. A cherry is a pair of leaf nodes (also called tips or terminal nodes)
in a phylogenetic tree that share a direct common ancestor.
}
\details{
The function uses \code{simulate.p.value = TRUE} in \code{\link[stats]{chisq.test}}
to compute the p-value via Monte Carlo simulation to improve reliability
regardless of whether the expected frequencies meet the assumptions of the chi-squared test
(i.e., expected counts of at least 5 in each category).
}
\examples{
tip1 <- c(0, 0, 1, 0.5, 1, 0.5)
tip2 <- c(0, 1, 1, 0, 0.5, 0.5)
compare_CherryFreqs(tip1, tip2)

}
