% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalyser.R
\name{MetaAnalyser}
\alias{MetaAnalyser}
\alias{MetaAnalyzer}
\title{The Meta-Analyser}
\usage{
MetaAnalyser(dat, rstudio = FALSE)

MetaAnalyzer(dat, rstudio = FALSE)
}
\arguments{
\item{dat}{Meta-analysis data. This should be a data frame with three columns, called "name", "est" and "se" giving the study name, study-specific parameter estimates and corresponding standard errors respectively.

Numeric or character study names are permitted.  If the data frame has more than three columns, the first three are used.  If the first three columns are called "name", "est" and "se" in some order, they are re-ordered appropriately, otherwise they are re-named.}

\item{rstudio}{The default of FALSE opens the app in the system default web browser.  If running RStudio and \code{rstudio=TRUE}, the app is opened in the RStudio built-in viewer.}
}
\value{
None
}
\description{
An interactive application to visualise meta-analysis data as a physical weighing machine
}
\details{
Opens a web browser with the interactive application.

If \code{dat} is omitted, the default \code{\link{magnesium}} dataset is used.

\code{MetaAnalyzer} is an alias for \code{MetaAnalyser}.
}
\examples{
\dontrun{MetaAnalyser(magnesium)}

}
\references{
J. Bowden and C. Jackson "Weighing evidence with the Meta-Analyser" The American Statistician (2016) Available online, \url{http://dx.doi.org/10.1080/00031305.2016.1165735}
}

