% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_log2FC.R
\name{plotly_vulcano}
\alias{plotly_vulcano}
\title{Plotly Log2FC Vulcano Plot}
\usage{
plotly_vulcano(
  metalyzer_se,
  cutoff_y = 0.05,
  cutoff_x = 1.5,
  class_colors = metalyzer_colors()
)
}
\arguments{
\item{metalyzer_se}{A Metalyzer object}

\item{cutoff_y}{A numeric value specifying the cutoff for q-value}

\item{cutoff_x}{A numeric value specifying the cutoff for log2 fold change}

\item{class_colors}{A csv file containing class colors hexcodes}
}
\value{
plotly object
}
\description{
This function returns a list with interactive 
vulcanoplot based on log2 fold change data.
}
\examples{

metalyzer_se <- MetAlyzer_dataset(file_path = example_mutation_data_xl())
metalyzer_se <- filterMetabolites(
  metalyzer_se,
  drop_metabolites = "Metabolism Indicators"
)
metalyzer_se <- renameMetaData(
  metalyzer_se,
  Mutant_Control = "Sample Description"
)
metalyzer_se <- calculate_log2FC(
  metalyzer_se,
  categorical = "Mutant_Control",
  impute_perc_of_min = 0.2,
  impute_NA = TRUE
)

p_vulcano <- plotly_vulcano(metalyzer_se, 
                       cutoff_y = 0.05,
                       cutoff_x = 1.5)

}
