% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{heart_transplant_tbl_df}
\alias{heart_transplant_tbl_df}
\title{Heart Transplant Data}
\format{
A tibble with 103 observations and 8 variables:
\describe{
  \item{id}{An integer identifier for each patient.}
  \item{acceptyear}{The year the patient was accepted for transplantation.}
  \item{age}{The age of the patient at the time of transplantation.}
  \item{survived}{A factor indicating whether the patient survived post-transplant (e.g., yes or no).}
  \item{survtime}{The time (in months) the patient survived after the transplant.}
  \item{prior}{A factor indicating whether the patient had prior heart conditions (e.g., yes or no).}
  \item{transplant}{A factor indicating the type of transplant (e.g., heart only, heart-lung).}
  \item{wait}{The wait time (in days) for the transplant.}
}
}
\source{
Data collected from heart transplant records to study patient outcomes and factors influencing survival.
}
\usage{
data(heart_transplant_tbl_df)
}
\description{
The dataset name has been changed to 'heart_transplant_tbl_df' to avoid confusion with other datasets from
packages in the R ecosystem and to follow the naming conventions of the 'MedDataSets' package.
The suffix '_tbl_df' indicates that this dataset is a tibble, helping to distinguish it from
other datasets within the package and from those in the broader R ecosystem. The original content
of the dataset has not been modified in any way.
}
\details{
This dataset contains information on heart transplant patients, including demographics, survival outcomes,
and wait times.
}
