% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stateMap.R
\name{stateMap}
\alias{stateMap}
\title{State level thematic map}
\usage{
stateMap(
  data = NULL,
  parameter = NULL,
  state_SFDF = "USCensusStates_02",
  breaks = NULL,
  palette = "brewer.blues",
  conusOnly = TRUE,
  stateCode = NULL,
  projection = NULL,
  stateBorderColor = "gray50",
  title = NULL,
  showLegend = TRUE,
  legendTitle = NULL,
  legendOrientation = "portrait",
  legendPosition = NULL
)
}
\arguments{
\item{data}{Dataframe containing values to plot. This dataframe
must contain a column named \code{stateCode} with the 2-character state code.}

\item{parameter}{Name of the column in \code{data} to use for coloring the map.}

\item{state_SFDF}{simple features data frame with US states. It's data
\code{@slot} must contain a column named \code{stateCode} with the
2-character state code.}

\item{breaks}{Numeric vector of break points.}

\item{palette}{A vector of colors or palette name from the \pkg{cols4all} package
(see \code{\link[cols4all:c4a]{cols4all::c4a}}).}

\item{conusOnly}{Logical specifying Continental US state codes. Ignored when
the \code{stateCode} argument is specified.}

\item{stateCode}{Vector of state codes to include on the map.}

\item{projection}{Named projection, \emph{e.g.} "EPSG:4326" or "WGS84" or proj4string.}

\item{stateBorderColor}{Color used for state borders.}

\item{title}{Vector of text strings to use as individual plot titles.
This must be the same length as 'parameter'.}

\item{showLegend}{Logical specifying whether or not to show the legend.}

\item{legendTitle}{Text string to use as the legend title.}

\item{legendOrientation}{Orientation of the legend. Either "portrait" or "landscape".}

\item{legendPosition}{A \emph{tm_pos} object generated with
\code{\link[tmap:tm_pos_in]{tmap::tm_pos_in()}} or
\code{\link[tmap:tm_pos_out]{tmap::tm_pos_out()}}.}
}
\value{
A ggplot object.
}
\description{
Uses the \pkg{tmap} package to generate a thematic map at the
state level. Input consists of a dataframe with \code{stateCode} identifiers.

Data to plot is specified with \code{parameter} argument. If \code{parameter}
is mult-valued, mutliple plots will be generated and displayed as "facets".

The returned object is a \pkg{tmap} ggplot object which can be further
modified with tmap or ggplot options.
}
\examples{
library(MazamaSpatialPlots)

stateMap(
  data = example_US_stateObesity,
  parameter = "obesityRate",
  stateBorderColor = "white",
  title = "2018 Obesity by State"
)

# Example of customization using tm_layout and breaks parameter
stateMap(
  data = example_US_stateObesity,
  parameter = "obesityRate",
  breaks = seq(20,38,3),
  stateBorderColor = 'black'
) +
  tmap::tm_layout(
    frame = TRUE,
    frame.double.line = TRUE,
    bg.color = "grey85",
    inner.margins  = .05
  ) +
  tmap::tm_title(
    text = 'Obesity Rate by State',
    size = 1.5,
    position = tmap::tm_pos_in("center", "top"),
    fontfamily = "serif"
  )

# Example using stateCode
stateMap(
  data = example_US_stateObesity,
  parameter = "obesityRate",
  stateCode = c('ME', 'NH', 'VT', 'MA', 'RI', 'CT'),
  stateBorderColor = 'black',
  legendPosition = tmap::tm_pos_in("right", "bottom")
) +
  tmap::tm_layout(
    frame = TRUE,
    frame.double.line = TRUE,
    bg.color = "grey85",
    inner.margins  = .08
  ) +
  tmap::tm_title(
    text = 'Obesity Rates in New England',
    size = 1.5,
    fontface = 2,
    fontfamily = "serif",
    position = tmap::tm_pos_in("center", "top")
  )
}
