% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{return_mc}
\alias{return_mc}
\title{S3 class \code{mc} object generating function}
\usage{
return_mc(S0, y, statistic, dgp, N, type, call, seed, pval)
}
\arguments{
\item{S0}{An atomic vector. Value of the test statistic
applied to the data.}

\item{y}{A vector or data frame.}

\item{statistic}{A function or a character string that specifies
how the statistic is computed. The function needs to input the
\code{y} and output a scalar.}

\item{dgp}{A function. The function inputs the first argument
\code{y} and outputs a simulated \code{y}. It should represent the
data generating process under the null. Default value is the function
\code{sample(y, replace = TRUE)}, i.e. the
bootstrap resampling of \code{y}.}

\item{N}{An atomic vector. Number of replications of the test
statistic.}

\item{type}{A character string. It specifies the type of test
the p-value function produces. The possible values are
\code{geq}, \code{leq}, \code{absolute} and \code{two-tailed}.
 Default is \code{geq}.}

\item{call}{An object of class \code{call}. Original call to \code{mmc}}

\item{seed}{An integer vector. Value of \code{.Random.seed} at the start of
\code{mmc} call.}

\item{pval}{An atomic vector. Monte Carlo p-value of \code{statistic}}
}
\description{
S3 class \code{mc} object generating function
}
\keyword{internal}
