% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{calculate_SWRC}
\alias{calculate_SWRC}
\title{SWRC - Biotic index (Stroud Water Research Centre - Biotic index)}
\usage{
calculate_SWRC(
  data,
  tolerances = list(Trichoptera_Hydropsychidae = 2.8, Trichoptera = 5, Plecoptera = 1,
    Ephemeroptera = 3.6, Diptera_Athericidae = 2, Diptera_Chironomidae_white = 6,
    Diptera_Chironomidae_red = 8, Diptera_Tipulidae = 3, Diptera_other = 6, Amphipoda =
    6, Gastropoda = 7, Oligochaeta = 8, Hirudinea = 8, Coleoptera = 4.6, Mollusca = 7,
    Nematoda = 8, Coleoptera = 4.6, Megaloptera = 3, Odonata_Zygoptera = 7, Isopda = 8,
    Decapoda = 5, Hemiptera = 0),
  print_results = TRUE
)
}
\arguments{
\item{data}{A data frame with predefined column names: Family, Abundance and Site. The dataset should be at the order level. If the family is not at the order level, it should be linked with an underscore (e.g., Trichoptera_Hydropsychidae).}

\item{tolerances}{Tolerance values are given by default.}

\item{print_results}{A logical value that determines whether or not to print the results. Defaults to TRUE.}
}
\value{
A data frame with two columns: SWRC Index (0-10) and Water Quality for each site.
}
\description{
SWRC - Biotic index (Stroud Water Research Centre - Biotic index)
}
\examples{
Site= c("L1", "L2", "L2")
Family=c("Capniidae",  "Aeshnidae", "Chloroperlidae")
Abundance=c(4,2,15)
test <- data.frame( Family, Abundance, Site)
calculate_SWRC(test)
}
\references{
Schmiedt, K., Jones, R. L., Brill, I. & Pikal, W. (1998). EPT (Epheromeraptera, Plecoptera and Trichoptera) Family Richness Modified Biotic Index.
SWRC – Stroud Water Research Centre (2023). Leaf Pack Network: Watersheds. Available from: www.stroudcenter.org/lpn/more/data.
SWRC (STROUD WATER RESEARCH CENTER) (2003). Water quality monitoring in the source water areas for New York City: an integrative approach. A report on the first phase of monitoring. Stroud Water Research Center, Avondale, PA, U.S.A.
}
