% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HT2test.R
\name{HT2test}
\alias{HT2test}
\title{Hotelling T Square Test}
\usage{
HT2test(data1,
        data2,
        mu0 = NULL,
        sample = "two",
        plot.scale = FALSE)
}
\arguments{
\item{data1}{The data frame or matrix must consist of only numbers, and the data must consist of only a single group or class. It should not contain columns that separate groups or classes.}

\item{data2}{The data frame or matrix must consist of only numbers, and the data must consist of only a single group or class. It should not contain columns that separate groups or classes. The \code{data2} is for comparison with \code{data1} and is not used to compare one sample to another.}

\item{mu0}{The mu0 is used to test the mean vector hypothesis of \code{data1}. It is only used to compare one-sample.}

\item{sample}{The options for specifying the number of groups for group comparisons are \code{one} and \code{two}, where \code{one} is used to compare one-sample and \code{two} is used to compare two-samples. (default sample = \code{two})}

\item{plot.scale}{If \code{TRUE}, the data will be scaled before calculating mean values and used in the plot. It has no direct effect on the data. It only applies to two samples. (default plot.scale = \code{FALSE})}
}
\value{
\item{One.HT2}{The Hotelling T square test in one-sample, showing the degrees of freedom required for the F test, the Hotelling t square statistic, the F test statistic, and the probability of significance.}
   \item{Mean.val.plot}{Plot the mean value parallel coordinates, representing the two samples using the mean values for each variable.}
   \item{Two.HT2}{The Hotelling T square test in two-sample, showing the degrees of freedom required for the F test, the Hotelling t square statistic, the F test statistic, and the probability of significance.}
}
\description{
The mean vector test (Hotelling T square test) to compare one sample or two samples that satisfy the multivariate normality test and the homogeneity of covariance matrices test.
}
\examples{
data(wine)
class1.wine <- subset(wine, class == 1)[, -1]
class2.wine <- subset(wine, class == 2)[, -1]
modified.class2.wine <- outlier(class2.wine, lim = 0, level = 0.05, option = "all")$modified.data

## one sample
value <- 0
p <- ncol(class1.wine)
mu0 <- matrix(rep(value, p), nrow = p, ncol = 1)
HT2test(data1 = class1.wine, mu0 = mu0, sample = "one")

## two sample
HT2test(data1 = class1.wine, data2 = modified.class2.wine, sample = "two", plot.scale = TRUE)


}
\references{
Johnson, R. A., & Wichern, D. W. (2007). Applied Multivariate Statistical Analysis (6th ed.). Pearson Prentice Hall.
}
\seealso{
\code{\link{mardiatest} for multivariate normality (Includes outlier remove)}

\code{\link{PPCCtest} for multivariate normality}

\code{\link{SPCCtest} for multivariate normality}

\code{\link{boxMtest} for homogeneity of covariance matrices}
}
\keyword{Hotelling.T^2}
