% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MUVR2_EN.R
\name{MUVR2_EN}
\alias{MUVR2_EN}
\title{MUVR2 with EN}
\usage{
MUVR2_EN(
  X,
  Y,
  ID,
  alow = 1e-05,
  ahigh = 1,
  astep = 11,
  alog = TRUE,
  nRep = 5,
  nOuter = 6,
  nInner,
  NZV = TRUE,
  DA = FALSE,
  fitness = c("AUROC", "MISS", "BER", "RMSEP", "wBER", "wMISS"),
  methParam,
  ML = FALSE,
  modReturn = FALSE,
  parallel = TRUE,
  keep = NULL,
  weigh_added = FALSE,
  weighing_matrix = NULL,
  ...
)
}
\arguments{
\item{X}{Predictor variables. NB: Variables (columns) must have names/unique identifiers. NAs not allowed in data. For multilevel, only the positive half of the difference matrix is specified.}

\item{Y}{Response vector (Dependent variable). For classification, a factor (or character) variable should be used. For multilevel, Y is calculated automatically.}

\item{ID}{Subject identifier (for sampling by subject; Assumption of independence if not specified)}

\item{alow}{alpha tuning: lowest value of alpha}

\item{ahigh}{alpha tuning: highest value of alpha}

\item{astep}{alpha tuning: number of alphas to try from low to high}

\item{alog}{alpha tuning: Whether to space tuning of alpha in logarithmic scale (TRUE; default) or normal/arithmetic scale (FALSE)}

\item{nRep}{Number of repetitions of double CV. (Defaults to 5)}

\item{nOuter}{Number of outer CV loop segments. (Defaults to 6)}

\item{nInner}{Number of inner CV loop segments. (Defaults to nOuter-1)}

\item{NZV}{Boolean for whether to filter out near zero variance variables (defaults to TRUE)}

\item{DA}{Boolean for Classification (discriminant analysis) (By default, if Y is numeric -> DA=FALSE. If Y is factor (or character) -> DA=TRUE)}

\item{fitness}{Fitness function for model tuning (choose either 'AUROC' or 'MISS' (default) for classification; or 'RMSEP' (default) for regression.)}

\item{methParam}{List with parameter settings for specified MV method (see function code for details)}

\item{ML}{Boolean for multilevel analysis (defaults to FALSE)}

\item{modReturn}{Boolean for returning outer segment models (defaults to FALSE). Setting modReturn=TRUE is required for making MUVR predictions using predMV().}

\item{parallel}{Boolean for whether to perform `foreach` parallel processing (Requires a registered parallel backend; Defaults to `TRUE`)}

\item{keep}{A group of confounders that you want to manually set as non-zero}

\item{weigh_added}{weigh_added}

\item{weighing_matrix}{weighing_matrix}

\item{...}{Pass additional arguments}
}
\value{
A MUVR object
}
\description{
"Multivariate modelling with Unbiased Variable selection" using Elastic Net (EN). Repeated double cross validation with tuning of variables using Elastic Net.
}
\examples{
\donttest{
data("freelive2")
nRep <- 2 # Number of MUVR2 repetitions
nOuter <- 4 # Number of outer cross-validation segments
regrModel <- MUVR2_EN(X = XRVIP2,
                      Y = YR2,
                      nRep = nRep,
                      nOuter = nOuter,
                      modReturn = TRUE)
}
}
