% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MUVR2.R
\name{MUVR2}
\alias{MUVR2}
\title{MUVR2 with PLS and RF}
\usage{
MUVR2(
  X,
  Y,
  ID,
  scale = TRUE,
  nRep = 5,
  nOuter = 6,
  nInner,
  varRatio = 0.75,
  DA = FALSE,
  fitness = c("AUROC", "MISS", "BER", "RMSEP", "wBER", "wMISS"),
  method = c("PLS", " RF", "ANN", "SVM"),
  methParam,
  ML = FALSE,
  modReturn = FALSE,
  logg = FALSE,
  parallel = TRUE,
  weigh_added = FALSE,
  weighing_matrix = NULL,
  keep,
  ...
)
}
\arguments{
\item{X}{Predictor variables. NB: Variables (columns) must have names/unique identifiers. NAs not allowed in data. For multilevel, only the positive half of the difference matrix is specified.}

\item{Y}{Response vector (Dependent variable). For classification, a factor (or character) variable should be used. For multilevel, Y is calculated automatically.}

\item{ID}{Subject identifier (for sampling by subject; Assumption of independence if not specified)}

\item{scale}{If TRUE, the predictor variable matrix is scaled to unit variance for PLS modeling.}

\item{nRep}{Number of repetitions of double CV. (Defaults to 5)}

\item{nOuter}{Number of outer CV loop segments. (Defaults to 6)}

\item{nInner}{Number of inner CV loop segments. (Defaults to nOuter - 1)}

\item{varRatio}{Ratio of variables to include in subsequent inner loop iteration. (Defaults to 0.75)}

\item{DA}{Boolean for Classification (discriminant analysis) (By default, if Y is numeric -> DA = FALSE. If Y is factor (or character) -> DA = TRUE)}

\item{fitness}{Fitness function for model tuning (choose either 'AUROC' or 'MISS' (default) for classification; or 'RMSEP' (default) for regression.)}

\item{method}{Multivariate method. Supports 'PLS' and 'RF' (default)}

\item{methParam}{List with parameter settings for specified MV method (see function code for details)}

\item{ML}{Boolean for multilevel analysis (defaults to FALSE)}

\item{modReturn}{Boolean for returning outer segment models (defaults to FALSE). Setting modReturn = TRUE is required for making MUVR predictions using predMV().}

\item{logg}{Boolean for whether to sink model progressions to `log.txt`}

\item{parallel}{Boolean for whether to perform `foreach` parallel processing (Requires a registered parallel backend; Defaults to `TRUE`)}

\item{weigh_added}{To add a weighing matrix when it is classfication}

\item{weighing_matrix}{The matrix used for get a miss classfication score}

\item{keep}{Confounder variables can be added. NB: Variables (columns) must match column names.}

\item{...}{additional argument}
}
\value{
A 'MUVR' object
}
\description{
"Multivariate modelling with Unbiased Variable selection" using PLS and RF.
Repeated double cross validation with tuning of variables in the inner loop.
}
\examples{
\donttest{
data(freelive2)
nRep <- 2 # Number of MUVR2 repetitions
nOuter <- 3 # Number of outer cross-validation segments
varRatio <- 0.6 # Proportion of variables kept per iteration
method <- 'PLS' # Selected core modeling algorithm
regrModel <- MUVR2(X = XRVIP2,
                   Y = YR2,
                   nRep = nRep,
                   nOuter = nOuter,
                   varRatio = varRatio,
                   method = method,
                   modReturn = TRUE)
}
}
