% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiscale_test.R
\name{multiscale_test}
\alias{multiscale_test}
\title{Carries out the multiscale test given that the values the estimatates of
long-run variance have already been computed.}
\usage{
multiscale_test(
  data,
  sigma = 1,
  sigma_vec = 1,
  n_ts = 1,
  grid = NULL,
  ijset = NULL,
  alpha = 0.05,
  sim_runs = 1000,
  deriv_order = 0,
  correction = TRUE,
  epidem = FALSE
)
}
\arguments{
\item{data}{Vector (in case of n_ts = 1) or matrix (in case of
n_ts > 1) that contains (a number of) time series
that needs to be analyzed. In the latter case,
each column of the matrix must contain one time series.}

\item{sigma}{The estimator of the square root of the long-run
variance \eqn{\sigma} in case of n_ts = 1,
or the estimator of the overdispersion parameter
\eqn{\sigma} in case of n_ts > 1 and epidemic = TRUE.}

\item{sigma_vec}{Vector that consists of estimators of the square root
of the long-run variances \eqn{\sigma_i} in case of
n_ts > 1 and epidemic = FALSE.}

\item{n_ts}{Number of time series analysed. Default is 1.}

\item{grid}{Grid of location-bandwidth points as produced by
the functions \code{\link{construct_grid}} or
\code{\link{construct_weekly_grid}}, it is a list with
the elements 'gset', 'bws', 'gtype'. If not provided,
then the defalt grid is used.
For the construction of the default grid,
see \code{\link{construct_grid}}.}

\item{ijset}{In case of multiple time series (n_ts > 1),
we need to know which pairs of time series to compare.
This matrix consists of all pairs of indices \eqn{(i, j)}
that we want to compare. If not provided, then all
possible pairwise comparison are performed.}

\item{alpha}{Significance level. Default is \eqn{0.05}.}

\item{sim_runs}{Number of simulation runs to produce quantiles.
Default is 1000.}

\item{deriv_order}{In case of a single time series, this denotes the order of
the derivative of the trend that we estimate.
Default is 0.}

\item{correction}{Logical variable, TRUE (by default) is we are using
\eqn{a_k} and \eqn{b_k}.}

\item{epidem}{Logical variable, TRUE if we are using
dealing with epidemic time trends. Default is FALSE.}
}
\value{
In case of n_ts = 1, the function returns a list
with the following elements:
   \item{testing_result}{A string that contains the result of the testing:
                         either the null hypothesis is rejected or not,
                         what is the confidence level and what is value of
                         the test statistic.}
   \item{quant}{Quantile that was used for testing calculated from
               the Gaussian distribution.}
   \item{statistics}{Value of the multiscale statistics.}
   \item{test_matrix}{Matrix of the test results for the multiscale test
                      defined in Khismatullina and Vogt (2019).
                      The matrix is coded as follows:
                      \itemize{
                      \item test_matrix[i,j] = -1: test rejects the null for the
                               j-th location \eqn{u} and the i-th bandwidth \eqn{h} and
                               indicates a decrease in the trend;
                      \item test_matrix[i,j] = 0: test does not reject the null
                               for the j-th location \eqn{u} and the i-th
                               bandwidth \eqn{h};
                      \item test_matrix[i,j] = 1:  test rejects the null for the
                               j-th location \eqn{u} and the i-th bandwidth \eqn{h} and
                               indicates an increase in the trend;
                      \item test_matrix[i,j] = 2: no test is carried out at j-th
                               location \eqn{u} and i-th bandwidth \eqn{h} (because
                               the point \eqn{(u, h)} is excluded from the grid
                               as specified by the 'deletions' option
                               in the function \code{\link{construct_grid}})}.
                      }
   \item{gset_with_vals}{A matrix that contains the values of the normalised 
                        kernel averages and test results for each pair
                        of location-bandwidth
                        with the corresponding location and bandwidth.}
In case of n_ts > 1, the function returns a list
with the following elements:
   \item{quant}{Quantile that was used for testing calculated from
               the gaussian distribution.}
   \item{statistics}{Value of the multiscale statistics.}
   \item{stat_pairwise}{Matrix of the values of the pairwise statistics.}
   \item{ijset}{The matrix that  consists of all pairs of indices
                \eqn{(i, j)} that we compared. The order of these
                pairs corresponds to the order in the list
                gset_with_vals.}
   \item{gset_with_vals}{A list of matrices, each matrix corresponding to a 
                        specific pairwise comparison. The order of the list 
                        is determined by ijset. Each matrix contains
                        the values of the normalisedkernel averages
                        for each pair of location-bandwidth
                        with the corresponding location and bandwidth.}
}
\description{
Carries out the multiscale test given that the values the estimatates of
long-run variance have already been computed.
}
