% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_time_varying_mediator_distal_outcome.R
\docType{data}
\name{data_time_varying_mediator_distal_outcome}
\alias{data_time_varying_mediator_distal_outcome}
\title{Example longitudinal dataset with time-varying mediator and distal outcome}
\format{
A data frame with \code{n * T_val} rows and the following columns:
\describe{
  \item{id}{Subject identifier (integer).}
  \item{dp}{Decision point index, strictly increasing within subject (integer).}
  \item{I}{Availability indicator at time \code{dp} (0/1).}
  \item{A}{Treatment at time \code{dp} (0/1).}
  \item{M}{Mediator at time \code{dp} (numeric; could be binary or continuous).}
  \item{X}{Time-varying covariate at time \code{dp} (numeric).}

  \item{A_prev}{Lagged treatment at time \code{dp-1} (0/1).}
  \item{M_prev}{Lagged mediator at time \code{dp-1} (numeric).}
  \item{X_prev}{Lagged covariate at time \code{dp-1} (numeric).}
  \item{I_prev}{Lagged availability at time \code{dp-1} (0/1).}

  \item{p_A}{Randomization probability for \code{A} at time \code{dp} (numeric in (0,1)).}
  \item{p_I}{Availability probability for \code{I} at time \code{dp} (numeric in (0,1)).}
  \item{mu_M}{Conditional mean of \code{M} given history (numeric; from DGM).}
  \item{mu_X}{Conditional mean of \code{X} given history (numeric; from DGM).}
  \item{mu_Y}{Conditional mean component for distal outcome \code{Y} (numeric; from DGM).}

  \item{Y}{Distal outcome, constant within subject (numeric).}
}
}
\source{
Simulated.
}
\usage{
data_time_varying_mediator_distal_outcome
}
\description{
A simulated long-format dataset used in the vignette and tests. Each row
corresponds to one subject–decision point. The distal outcome `Y` is
constant within subject (repeated on every row for that subject).
}
\details{
Generated by \code{dgm_time_varying_mediator_distal_outcome()} in the package
source. Intended for illustrating \code{mcee} usage. No missing values.
}
\examples{
data(data_time_varying_mediator_distal_outcome)
str(data_time_varying_mediator_distal_outcome)
}
\seealso{
\code{\link{mcee}}, \code{\link{mcee_general}}, \code{\link{mcee_userfit_nuisance}}
}
\keyword{datasets}
