% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqmf_utils.r
\name{aicbic}
\alias{aicbic}
\title{aicbic returns the AIC and BIC for a given model}
\usage{
aicbic(model, dat, nLL = TRUE)
}
\arguments{
\item{model}{the optimum model fitted by either optim, nlm, or nlminb}

\item{dat}{the data set used in the modelling, or just n the number of
observations; it can distinguish between them}

\item{nLL}{uses negative log-likelihood? default=TRUE}
}
\value{
a vector of four numbers, AIC first, then BIC, then negLL or 
    SSQ, depending on nLL, then number of parameters p
}
\description{
aicbic calculates and returns the AIC and BIC using the
    standard definitions. It defaults to assuming that negative log-
    likelihoods have been used in the model fitting, but provides the
    option of having used SSQ (set nLL to FALSE). If using SSQ it 
    uses Burnham and Anderson's (2002) definition but sets BIC to NA. 
    aicbic can recognize the outputs from optim, nlm, and nlminb.
}
\examples{
data(blackisland); bi <- blackisland
param <- c(Linf=170.0,K=0.3,sigma=4.0)
modelvb <- nlm(f=negNLL,p=param,funk=fabens,observed=bi$dl,indat=bi,
               initL="l1",delT="dt") # could have used the defaults
# Do not worry about the warning messages
aicbic(modelvb,blackisland)  # 588.3382 596.3846 291.1691   3
}
\references{
Burnham, K.P. and D.R. Anderson (2002) \emph{Model Selection and 
    Inference. A Practical Information-Theoretic Approach.} Second Edition 
    Springer-Verlag, New York. 488 p.
}
