% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMLR.R
\name{randomizeTau}
\alias{randomizeTau}
\title{Transformation of the observed time vector tau. Data preparation stage for simulation}
\usage{
randomizeTau(tau, p, k0 = 2, k1 = 1)
}
\arguments{
\item{tau}{Vector (n x 1), n - number of observations}

\item{p}{Scalar (from 1 to +inf), random number for simulation. The default value is 1}

\item{k0}{Scalar (from 1 to +inf). Multiplicative parameter for transforming the initial value
The default is k0 = 2.}

\item{k1}{Scalar. The number of digits after the comma when rounded.
The default is 1.}
}
\value{
Vector with new observation times, according to user preferences.
}
\description{
Additional function to be used for simulation purposes (academical or research).
Transforming of the observed time vector tau according to user preferences. Random disturbances are entered in the initial values of the vector tau.
The expectation of new observed times coincides with initial values of vector tau.
}
\details{
Initial values of observation times are multiplied by a random value ($tau_{i}$ x k x rnd(0, 1)). All times are independent and time of ith observation has uniform distribution on (0, k$tau_{i}$).
}
\examples{
tGiven <- matrix (c(6,4.8,1,2.6,6.4,1.7,2.9,4.4,1.5,3.4), nrow = 10, ncol = 1)
randomizeTau(tGiven,1,2,2)
}
