% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLGL.R
\name{MLGL}
\alias{MLGL}
\alias{MLGL.default}
\alias{MLGL.formula}
\title{Multi-Layer Group-Lasso}
\usage{
MLGL(X, ...)

\method{MLGL}{default}(
  X,
  y,
  hc = NULL,
  lambda = NULL,
  weightLevel = NULL,
  weightSizeGroup = NULL,
  intercept = TRUE,
  loss = c("ls", "logit"),
  sizeMaxGroup = NULL,
  verbose = FALSE,
  ...
)

\method{MLGL}{formula}(
  formula,
  data,
  hc = NULL,
  lambda = NULL,
  weightLevel = NULL,
  weightSizeGroup = NULL,
  intercept = TRUE,
  loss = c("ls", "logit"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{X}{matrix of size n*p}

\item{...}{Others parameters for \code{\link[gglasso]{gglasso}} function}

\item{y}{vector of size n. If loss = "logit", elements of y must be in \{-1,1\}}

\item{hc}{output of \code{\link{hclust}} function. If not provided, \code{\link{hclust}} is run with \code{ward.D2} method.
User can also provide the desired method: "single", "complete", "average", "mcquitty",
"ward.D", "ward.D2", "centroid", "median".}

\item{lambda}{lambda values for group lasso. If not provided, the function generates its own values of lambda}

\item{weightLevel}{a vector of size p for each level of the hierarchy. A zero indicates that the level will be ignored.
If not provided, use 1/(height between 2 successive levels). Only if \code{hc} is provided}

\item{weightSizeGroup}{a vector of size 2*p-1 containing the weight for each group.
Default is the square root of the size of each group. Only if \code{hc} is provided}

\item{intercept}{should an intercept be included in the model ?}

\item{loss}{a character string specifying the loss function to use, valid options are: "ls" least squares loss (regression)
and "logit" logistic loss (classification)}

\item{sizeMaxGroup}{maximum size of selected groups. If NULL, no restriction}

\item{verbose}{print some information}

\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the
model to be fitted.}

\item{data}{an optional data.frame, list or environment (or object coercible by as.data.frame to a data.frame) containing
the variables in the model. If not found in data, the variables are taken from environment (formula)}
}
\value{
a MLGL object containing:
\describe{
  \item{lambda}{lambda values}
  \item{b0}{intercept values for \code{lambda}}
  \item{beta}{A list containing the values of estimated coefficients for each values of \code{lambda}}
  \item{var}{A list containing the index of selected variables for each values of \code{lambda}}
  \item{group}{A list containing the values index of selected groups for each values of \code{lambda}}
  \item{nVar}{A vector containing the number of non zero coefficients for each values of \code{lambda}}
  \item{nGroup}{A vector containing the number of non zero groups for each values of \code{lambda}}
  \item{structure}{A list containing 3 vectors. var: all variables used. group: associated groups.
  weight: weight associated with the different groups.
  level: for each group, the corresponding level of the hierarchy where it appears and disappears.
  3 indicates the level with a partition of 3 groups.}
  \item{time}{computation time}
  \item{dim}{dimension of \code{X}}
  \item{hc}{Output of hierarchical clustering}
  \item{call}{Code executed by user}
}
}
\description{
Run hierarchical clustering following by a group-lasso on all the different partitions.
}
\examples{
set.seed(42)
# Simulate gaussian data with block-diagonal variance matrix containing 12 blocks of size 5
X <- simuBlockGaussian(50, 12, 5, 0.7)
# Generate a response variable
y <- X[, c(2, 7, 12)] \%*\% c(2, 2, -2) + rnorm(50, 0, 0.5)
# Apply MLGL method
res <- MLGL(X, y)
}
\seealso{
\link{cv.MLGL}, \link{stability.MLGL}, \link{listToMatrix}, \link{predict.MLGL}, \link{coef.MLGL}, \link{plot.cv.MLGL}
}
\author{
Quentin Grimonprez
}
