% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.MFT.R
\name{plot.MFT}
\alias{plot.MFT}
\title{plot.MFT}
\usage{
\method{plot}{MFT}(x, col = NULL, ylab1 = NULL, ylab2 = NULL,
  cex.legend = 1.2, cex.diamonds = 1.4, main = TRUE, plot.Q = TRUE,
  plot.M = TRUE, plot.h = TRUE, breaks = NULL, wid = NULL, ...)
}
\arguments{
\item{x}{object of class MFT}

\item{col}{"gray" or vector of colors of length(H). Colors for (G_ht) plot, default: NULL -> rainbow colors from blue to red}

\item{ylab1}{character, ylab for 1. graphic}

\item{ylab2}{character, ylab for 2. graphic}

\item{cex.legend}{numeric, size of annotations in plot}

\item{cex.diamonds}{numeric, size of diamonds that indicate change points}

\item{main}{logical, indicates if title and subtitle are plotted}

\item{plot.Q}{logical, indicates if rejection threshold Q is plotted}

\item{plot.M}{logical, indicates if test statistic M is plotted}

\item{plot.h}{logical, indicates if a legend for the window set H is plotted}

\item{breaks}{integer, >0, number of breaks in rate histogram}

\item{wid}{integer, >0, width of bars in variance histogram}

\item{...}{additional parameters}
}
\description{
Plot method for class 'mft'.
}
\examples{
# Rate change detection in Poisson process 
# with three change points (at t = 250, 600 and 680)
set.seed(0)
Phi1 <- runif(rpois(1,lambda=390),0,250)
Phi2 <- runif(rpois(1,lambda=380),250,600)
Phi3 <- runif(rpois(1,lambda=200),600,680)
Phi4 <- runif(rpois(1,lambda=400),680,1000)
Phi  <- sort(c(Phi1,Phi2,Phi3,Phi4)) 
mft  <- MFT.rate(Phi)
plot(mft)


}
\references{
Michael Messer, Marietta Kirchner, Julia Schiemann, Jochen Roeper, Ralph Neininger and Gaby Schneider (2014).
A multiple filter test for the detection of rate changes in renewal processes with varying variance. The Annals of Applied Statistics 8(4): 2027-67
<doi:10.1214/14-AOAS782>
}
\seealso{
\code{\link{MFT.rate}, \link{MFT.variance}, \link{MFT.mean}, \link{MFT.peaks}, \link{summary.MFT}}
}
\author{
Michael Messer, Stefan Albert, Solveig Plomer and Gaby Schneider
}
