% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMA.R
\name{MMA}
\alias{MMA}
\title{Multiscale Multifractal Analysis}
\usage{
MMA(tsx, scale, qminmax, ovlap=0, m=2)
}
\arguments{
\item{tsx}{Univariate time series (must be a vector or a ts object).}

\item{scale}{Vector of scales.}

\item{qminmax}{Vector of two values min and max of q-order of the moment.}

\item{ovlap}{Overlapping parameter (By default ovlap=0: no overlapping).}

\item{m}{Polynomial order for the detrending (by defaults m=2).}
}
\value{
A matrix with three columns (q-order, scale (s), and the scale exponent).
}
\description{
Applies the Multiscale Multifractal Analysis (MMA) on time series.
}
\note{
The original code of this function is in Matlab, you can find it on the
following website \href{https://physionet.org/physiotools/mma/}{Physionet}. See
references below.
}
\examples{

\dontrun{
library(MFDFA)
library(plotly)
library(plot3D)

a<-0.6
N<-800
tsx<-MFsim(N,a)
scale=10:100
res<-MMA(tsx, scale, qminmax=c(-10,10), ovlap=0, m=2)

## Visualisation 1:
S_exponent <- matrix(res[,3], nrow=length(unique(res[,1])), ncol=length(min(scale):(max(scale)/5)))
m_scale <- unique(res[,2])
q <- unique(res[,1])
plot_ly() \%>\% add_surface(x = ~m_scale, y = ~q,
                         z = ~S_exponent)

## Visualisation 2:
image2D(S_exponent, xlab="q", ylab="scale", axes=F)
axis(1, seq(0,1,0.1), round(quantile(q, seq(0, 1, 0.1)), 2))
axis(2, seq(0,1,0.1), round(quantile(m_scale, seq(0, 1, 0.1)), 2))
}

}
\references{
J. Feder, Fractals, Plenum Press, New York, NY, USA, 1988.

J. Gieraltowski, J. J. Zebrowski, and R. Baranowski,
Multiscale multifractal analysis of heart rate variability recordings
http://dx.doi.org/10.1103/PhysRevE.85.021915

Goldberger AL, Amaral LAN, Glass L, Hausdorff JM, Ivanov PCh, Mark RG,
Mietus JE, Moody GB, Peng C-K, Stanley HE. PhysioBank, PhysioToolkit,
and PhysioNet: Components of a New Research Resource for Complex
Physiologic Signals. Circulation 101(23):e215-e220.

J. W. Kantelhardt, S. A. Zschiegner, E. Koscielny-Bunde, S. Havlin,
A. Bunde, H. Stanley, Multifractal detrended fluctuation analysis of
nonstationary time series, Physica A: Statistical Mechanics and its
Applications, 316 (1) (2002) 87 – 114.

J. Gierałtowski, J. J. Żebrowski, and R. Baranowski, "Multiscale
multifractal analysis of heart rate variability recordings with a
large number of occurrences of arrhythmia," Phys. Rev. E 85, 021915 (2012)
}
