% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/further_functions.R
\name{compare_loop_list}
\alias{compare_loop_list}
\title{Compare two loop lists}
\usage{
compare_loop_list(loop_list_a, loop_list_b)
}
\arguments{
\item{loop_list_a, loop_list_b}{Loop lists with columns \code{loop} and
\code{sign}, for example generated from \code{\link{find_loops}}.}
}
\value{
A list with 5 (possible empty) vectors as entries.
\itemize{
\item \code{ind_a_id} - indices of the loops in the first loop list that occur
identically in the second loop list
\item \code{ind_a_switch} - indices of the loops in the first loop list that occur
in the second loop list with a different sign
\item \code{ind_a_notin} - indices of the loops in the first loop list that do not
occur in the second loop list
\item \code{ind_b_id} - indices of loops in the second loop list corresponding to
the loops reported in \code{ind_a_id}
\item \code{ind_b_switch} - indices of loops in the second loop list corresponding
to loops reported in \code{ind_a_switch}.
}
}
\description{
Compared two loop lists and returns the indices of those loops that are
identical in both lists, that switch only the sign or that do not occur
in both lists
}
\details{
Indices of loops are given with respect to the order of the
loops in the first supplied loop list as well as for the second loop
list. The loops are sorted to represent their loops starting from the
smallest variable index (using the function \code{\link{sort_loop_index}}).
}
\examples{
#sample Jacobian matrix of a system with 4 variables
jac_matrix <- rbind(c(-1,0,0,-1),c(1,-1,0,1),c(0,1,-1,0),c(0,0,1,-1))
#find the feedback loops of the system
loop_list <- find_loops(jac_matrix,10)
#a slightly different Jacobian matrix of the system with 4 variables
jac_matrix_alt <- rbind(c(-1,0,0,1),c(1,-1,0,-1),c(0,1,-1,0),c(0,0,1,-1))
#find the feedback loops of the system
loop_list_alt <- find_loops(jac_matrix_alt,10)
#compare the loop lists
comp_loop_list <- compare_loop_list(loop_list,loop_list_alt)
#loops that switch sign
comp_loop_list[['ind_a_switch']]

}
