% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/further_functions.R
\name{find_edge}
\alias{find_edge}
\title{Detecting loops with a certain edge}
\usage{
find_edge(loop_list, source_node, target_node)
}
\arguments{
\item{loop_list}{Dataframe with a column \code{loop} that contains the lists
of loops, e.g. obtained from \code{\link{find_loops}}.}

\item{source_node}{Index of the variable that is the source of the
queried interaction, i.e. that regulates the target node.}

\item{target_node}{Index of the variable that is the target of the
queried interaction, i.e. that is regulated by the source node.}
}
\value{
A vector that gives the indices in the loop list of those loops
that contain the indicated edge.
}
\description{
Finds those loops in a loop list that contain a regulation
from a certain variable (source node) to a certain variable (target node).
}
\examples{
#sample Jacobian matrix of a system with 4 variables
jac_matrix <- rbind(c(-1,0,0,-1),c(1,-1,0,1),c(0,1,-1,0),c(0,0,1,-1))
#find the feedback loops of the system
loop_list <- find_loops(jac_matrix,10)
#find the loops containing the regulation from variable 3 to variable 4
inds_3_to_4 <- find_edge(loop_list,3,4)

}
