% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Attribution_sullivan.R
\name{Attribution_sullivan}
\alias{Attribution_sullivan}
\title{Longitudinal Attribution of Disability and Death Based on Sullivan Method}
\usage{
Attribution_sullivan(object, type.attrib = "both")
}
\arguments{
\item{object}{A fitted \code{LongDecompHE} object returned by \code{copula_additive}.}

\item{type.attrib}{Type of attribution output to return; can be one of:
\itemize{
  \item \code{"rel"}: Relative contributions of causes over age (i.e., time);
  \item \code{"abs"}: Absolute contributions of causes over age (i.e., time);
  \item \code{"both"}: Both relative and absolute contributions (default).
}}
}
\value{
A list containing the following components:
\describe{
  \item{Relative_Contributions_1}{Matrix of relative contributions to disability prevalence by cause and age}
  \item{Relative_Contributions_2}{Matrix of relative contributions to death probability by cause and time}
  \item{Absolute_Contributions_1}{Matrix of absolute contributions to disability prevalence by cause and age}
  \item{Absolute_Contributions_2}{Matrix of absolute contributions to death probability by cause and time}
  \item{var_list}{Vector of covariate names used in the model}
  \item{time_list}{Vector of attribution ages}
  \item{copula}{Character indicating attribution type ("Attribution_sullivan")}
}
#' Additional components \code{copula} and \code{summary} are included for compatibility with generic
}
\description{
Computes the relative and/or absolute contributions of causes (i.e., covariates) to disability and death across a specified age range,
based on a copula regression models with semiparametric additive hazards margins object. This attribution approach adopts a Sullivan method
for cohort health expectancy.
}
\details{
This function loops over all attribution-eligible ages in the fitted model (from 0 to \code{floor(u-1)}),
Use \code{summary()} on the returned object to print the attribution tables.
}
\examples{
\donttest{
# Fit a model (see copula_additive)
data(simulated_dataA)
u1 = u2 = max(simulated_dataA$visit_time)
var_list = c("Z1", "Z2", "Z3")
copula_additive_model <-  copula_additive(data = simulated_dataA,
                                        var_list = var_list,
                                        l1=0, u1 = u1, m1 = 3,
                                        l2=0, u2 = u2, m2 = 3,
                                        method = "combined", iter=1000,
                                        stepsize=1e-6,
                                        hes = TRUE,
                                        control = list(maxit = 10000))
summary(copula_additive_model)
# Attribution analysis (both relative and absolute)
attributionA <- Attribution_sullivan(object = copula_additive_model, type.attrib = "both")
summary(attributionA)

# Relative only
attributionA_rel <- Attribution_sullivan(object = copula_additive_model, type.attrib = "rel")

# Absolute only
attributionA_abs <- Attribution_sullivan(object = copula_additive_model, type.attrib = "abs")
}
}
\seealso{
\code{\link{copula_additive}} for model fitting;
\code{\link{summary.LongDecompHE}} for output methods.
}
