###### functions for building likelihoods #######
bern <- function (j, m, l, u, t)
{
  if (j > m) {
    b = 0
  }
  else {
    b = (factorial(m)/(factorial(j) * factorial(m - j))) *
      (((t - l)/(u - l))^j) * ((1 - (t - l)/(u - l))^(m -
                                                        j))
  }
  return(b)
}

bern_derivative <- function (j, m, l, u, t)
{
  if (j != 0) {
    b = m * bern(j - 1, m - 1, l, u, t)/(u - l) - m * bern(j,
                                                           m - 1, l, u, t)/(u - l)
  }
  else if (j == 0) {
    b = -1 * m * (u - t)^(m - 1)/((u - l)^m)
  }
  return(b)
}


C_Q <- function(S1, S2,kappa,alpha) {
  (1 + ((S1^(-1/kappa)-1)^(1/alpha) + (S2^(-1/kappa)-1)^(1/alpha))^alpha)^(-kappa)
}



gh_F<-function(u1,u2,eta)
{
  c_val<-exp(-((-log(u1))^eta+(-log(u2))^eta)^(1/eta))
  return(c_val)
}
