#' Print method for logic forest predictions
#'
#' Displays the results of a prediction from a logic forest model.
#'
#' @param x An object of class \code{"LFprediction"}.
#' @param ... Additional arguments (currently ignored).
#'
#' @return No return value. This function is called for its side effects (printing).
#'
#' @export

print.LFprediction<-function(x, ...)
{
  if(inherits(x)!="LFprediction")
    stop("x not of class LFprediction")
  prdct<-x$LFprediction
  if(model.type=="Classification")
  {
    prop<-x$proportion_one

    if(length(x)==3)
    {
      cat("OOB Predicted values\n")
      cat("\n")
      print.default(prdct, quote=FALSE)
      cat("\n")
      cat("Proportion of OOB trees that predict 1")
      cat("\n")
      print.default(prop, quote=FALSE)
    }
    if(length(x)==4)
    {
      cat("Predicted values\n")
      cat("\n")
      print.default(prdct, quote=FALSE)
      cat("\n")
      cat("Proportion of trees that predict 1")
      cat("\n")
      print.default(prop, quote=FALSE)
    }
  }

  if(model.type=="Linear Regression")
  {
    if(length(x)==4)
    {
      cat("OOB Predicted values\n")
      cat("\n")
      print.default(prdct, quote=FALSE)
      cat("\n")
      cat("OOB mean squared error")
      cat("\n")
      print.default(x$OOBmse, quote=FALSE)
    }
    if(length(x)==3)
    {
      cat("Predicted values\n")
      cat("\n")
      print.default(prdct, quote=FALSE)
    }
  }
}
